-- Fichero FSQL_F.sql
----------------------------------------------------------------------
-- * PAQUETES PL/SQL: FSQL_FUNCTIONS y FSQL_FUNCTIONS2
-- * OBJETIVO:
--	# FSQL_FUNTIONS:	Fichero FSQL_F.SQL
--	                	Funciones para MOSTRAR atributos difusos y
--	               	para COMPARAR atributos y constantes difusas
--	               	con los comparadores de Posibilidad y Necesidad:
--	               	FEQ, FGT, FGEQ, FLT, NFLEQ, NFEQ, NFGT, NFGEQ, NFLT y NFLEQ.
--	# FSQL_FUNTIONS2:	Fichero FSQL_F2.SQL
--	                	Funciones para COMPARAR atributos y constantes difusas
--	               	con los comparadores de Posibilidad y Necesidad:
--	               	MGT, MLT, NMGT y NMLT.
-- * AUTOR         : Jos Galindo G.
-- * COMPARADORES DIFUSOS: Se han dividido en dos paquetes debido a la
--   imposibilidad de crear un nico paquete tan grande.
--	# De Posibilidad (Possibility):
--		FEQ		Posiblemente Igual Difuso
--		FGT		Posiblemente Mayor Difuso
--		FGEQ		Posiblemente Mayor o Igual Difuso
--		FLT		Posiblemente Menor Difuso
--		FLEQ		Posiblemente Menor o Igual Difuso
--		MGT		Posiblemente Mucho Mayor Que
--		MLT		Posiblemente Mucho Menor Que
--	# De Necesidad (Necessity):
--		NFEQ		Necesariamente Igual Difuso
--		NFGT		Necesariamente Mayor Difuso
--		NFGEQ		Necesariamente Mayor o Igual Difuso
--		NFLT		Necesariamente Menor Difuso
--		NFLEQ		Necesariamente Menor o Igual Difuso
--		NMGT		Necesariamente Mucho Mayor Que
--		NMLT		Necesariamente Mucho Menor Que
-- * RESTRICTIVIDAD de los COMPARADORES:
--   Hay comparadores cuyos resultados de comparacin incluyen unos a otros.
--   En modo crisp, p.e., el resultado del comparador '>=' incluye al de '>'.
--   Decimos entonces que '>' es ms restrictivo que '>='.
--   O sea, los comparadores ms restrictivos nunca recuperarn ms tuplas
--   y las tuplas recuperadas nunca tendrn un grado mayor.
--   Por familias, de ms restrictivo a menos, tenemos el siguiente orden:
--		NFEQ > FEQ
--		NFGT > FGT > NFGEQ > FGEQ
--		NFLT > FLT > NFLEQ > FLEQ
--		NMGT > MGT
--		NMLT > MLT
-- * EQUIVALENCIAS entre COMPARADORES: Igual que se cumple que (A>B)=(B<A),
--   entre los comparadores difusos, por su definicin, existen las
--   siguientes equivalencias:
--		A FGT  B = B NFLEQ A
--		A FLT  B = B NFGEQ A
--		A FGEQ B = B FLEQ  A
--		A NFGT B = B NFLT  A
--		A NMGT B = B NMLT  A
--   Estas equivalencias se cumplen siempre excepto cuando comparamos un
--   valor UNKNOWN, UNDEFINED o NULL con un comparador de Necesidad.
--   En ese caso siempre devuelve 0.
--   Ejemplos:	UNKNOWN FLT crisp   --> Devuelve 1
--			crisp NFGEQ UNKNOWN --> Devuelve 0 (sera 1 por la frmula)
--   El segundo ejemplo slo puede efectuarse cuando la parte dcha. de la
--   comparacin es una columna difusa tipo 2. Por lo que es poco probable
--   que nos interese recuperar esa tupla. Adems, al usar un comparador
--   de Necesidad se est indicando claramente que se desean recuperar
--   pocas e interesantes tuplas.
--   Otro Ejemplo:	NULL FLT crisp   --> Devuelve 1
--				crisp NFGEQ NULL --> Devuelve 0
-- * MODO de FUNCIONAMIENTO:
--   La funcin FSQL_PKG.FSQL2SQL incluir llamadas a estas funciones para
--   formar la traduccin de una sentencia en FSQL a otra en SQL.
--   Por tanto, estas funciones no son para ser utilizadas directamente por un usuario,
--   sino que un programa 'CLIENTE FSQL' ser el que, tras traducir la consulta a SQL,
--   ejecute dicha sentencia que contendr llamadas a las funciones de este paquete.
-- * REQUISITOS:
--   Para el correcto funcionamiento de los componentes de este paquete es
--   imprescindible que las tablas y atributos estn correctamente definidos.
--   Es decir, que sigan correctamente el modelo GEFRED de Bases de Datos
--   Relacionales Difusas (ver Tesis Doctoral de J.M. Medina), incluyendo algunas
--   modificaciones (Tesis Doctoral de J. Galindo G. --en realizacin--).
----------------------------------------------------------------------

----------------------------------------------------------------------
-- Funciones para el manejo de valores/atributos difusos a travs de SQL.
-- Atributos tipo 2                 Atributos tipo 3
-- -----------------------------    ---------------------
-- F_TYPE=0 --> UNKNOWN              UNKNOWN
--       =1 --> UNDEFINED            UNDEFINED
--       =2 --> NULL                 NULL
--       =3 --> CRISP (o tipo 1)     SIMPLE
--       =4 --> LABEL                DIST. de POSIBILIDAD
--       =5 --> INTERVALO
--       =6 --> APROX
--       =7 --> TRAPECIO
----------------------------------------------------------------------
-- Ecuacin de una recta que pasa por (X1,0)-(X2,1): y=(x-x1)/(x2-x1)
----------------------------------------------------------------------

--********************- DIAGRAMA de COMPARACIONES -********************
-- FFF equivale a cualquier comparador difuso

-------> Atributos difusos tipo 1:
-- Formato con ctes:
--     fcol_t1 FFF [X,Y]                         --> FFF_crisp_finter
--     fcol_t1 FFF #Aprox                        --> FFF_crisp_aprox
--     fcol_t1 FFF $label,fcol_t1 FGT $[a,b,c,d] --> FFF_crisp_trape
--     fcol_t1 FFF n                             --> FFF_t1_t1
-- Formato con columna: fcol_t1 FFF fcol_t2      --> FFF_t1_t2
--                      fcol_t1 FFF fcol_t1      --> FFF_t1_t1
-- Formato con expresin: fcol_t1 FFF expr_crisp --> FFF_t1_t1
-- Formato con ctes. especiales: UNKNOUN, UNDEFINED y NULL
--    fcol_t1 FFF (UNKNOUN|UNDEFINED|NULL)       --> Error
--    fcol_t1 IS [NOT] (UNKNOUN|UNDEFINED)       --> Error
--    fcol_t1 IS [NOT] NULL                      --> NULL clsico (no difuso)
-- NOTAS:
--	1. En la funcin FFF_t1_t1 se difumina el valor de la dcha. a un valor
--	   APROX. con el margen del atributo de la izda. Si no se quiere que
--       haga eso, entonces, usar un comparador Crisp y no uno Difuso.
--	2. En la funcin FFF_crisp_finter se difumina el valor de la dcha. a un valor
--       TRAPECIO con el margen del atributo de la izda. Si no se quiere que
--       haga eso, entonces, usar un comparador Crisp (BETWEEN,>,<...).
--	3. Con los comparadores [N]MGT/[N]MLT se difuminan los valores no difusos:
--       Un crisp pasa a ser un aprox. y un intervalo pasa a ser un trapecio,
--       utilizando el margen del atributo de la izda.
--	4. Todas estas funciones de comparacin para tipos 1 son equivalentes
--       en sus versiones de Posibilidad y Necesidad para los siguientes
--       comparadores: FEQ, FGT, FGEQ, FLT y FLEQ. Es decir, por ejemplo,
--       la funcin FEQ_t1_t1 es equivalente a NFEQ_t1_t1.
--       Por tanto, las funciones de Necesidad no estn implementadas.
--       El servidor FSQL deber usar las funciones de Posibilidad en este caso.
--       Para los comparadores MGT y MLT no ocurre eso ya que los valores crisp
--       son transformados en aprox: crips + - margen.

-------> Atributos difusos tipo 2:
-- Formato con ctes:
--    fcol_t2 FFF [X,Y]                            --> FFF_inter
--    fcol_t2 FFF #Aprox                           --> FFF_aprox
--    fcol_t2 FFF $label,fcol_t1 FGT $[a,b,c,d]    --> FFF_trape
--    fcol_t2 FFF n                                --> FFF_crisp
-- * Formato con columna:
--    fcol_t2 FFF fcol_t1                          --> FFF_crisp
--    fcol_t2 FFF fcol_t2                          --> FFF
-- * Formato con expresin: fcol_t2 FFF expr_crisp --> FFF_crisp
-- * Formato con ctes. especiales: UNKNOUN, UNDEFINED y NULL
--    (Si se usa otro comparador distinto de FEQ, da error)
--    fcol_t2 FEQ UNKNOUN                          --> FEQ_UNKNOWN
--    fcol_t2 FEQ UNDEFINED                        --> FEQ_UNDEFINED
--    fcol_t2 FEQ NULL                             --> FEQ_NULL
--    fcol_t2 IS [NOT] (UNKNOUN|UNDEFINED|NULL)    --> Comparacin clsica
-- * Formato con comparadores clsicos: fcol_t2 = 'CADENA'
--   donde el = representa cualquier comparador clsico y la 'CADENA'
--   representa una cadena de caracteres (las comillas son obligatorias).
--   Esta comparacin compara la 'CADENA' con la representacin grfica del
--   atributo (que es tambin de tipo VARCHAR2).
-- NOTAS:
--	1. Con las ctes. (UNKNOUN|UNDEFINED|NULL) slo se puedenusar el
--       comparador FEQ y la comparacin con IS.
--	2. Las expresiones a la izda. y las NO crisp a la dcha, son tratadas
--       como externas a la comparacin. Ej: 5+Atrib FEQ Atrib_t2+6
--	3. Con los comparadores [N]MGT/[N]MLT se difuminan los valores no difusos:
--       Un crisp pasa a ser un aprox. y un intervalo pasa a ser un trapecio,
--       utilizando el margen del atributo de la izda.

-------> Atributos difusos tipo 3: Slo FEQ
-- * Formato con ctes:
--    fcol_t3 FEQ $label                         --> FEQ3_label
--                                                   FEQ3_label_LEN1
-- * Formato con columna:
--    fcol_t3 FEQ fcol2_t3                       --> FEQ3
-- * Formato con ctes. especiales: UNKNOUN, UNDEFINED y NULL
--    fcol_t3 FEQ (UNKNOUN|NULL)                 --> FEQ3_UNKNOWN_NULL
--    fcol_t3 FEQ UNDEFINED                      --> FEQ3_UNDEFINED
--    fcol_t3 IS [NOT] (UNKNOUN|UNDEFINED|NULL)  --> Comparacin clsica
-- * Formato con comparadores clsicos: fcol_t3 = 'CADENA'
--   donde el = representa cualquier comparador clsico y la 'CADENA'
--   representa una cadena de caracteres (las comillas son obligatorias).
--   Esta comparacin compara la 'CADENA' con la representacin grfica del
--   atributo (que es tambin de tipo VARCHAR2).

--********************************************************************
-- OTRAS OBSERVACIONES:
--	1. El tipo NUMBER permite por defecto 38 dgitos (el mximo posible).
--	   Si se desea menos se podra especificar: NUMBER(precisin,escala)
--	2. Las variables OBJ y COl almacenan el identificador para un OBJeto
--	   y para una COLumna, respectivamente. Su tipo es NUMBER.

--**************************************************************
--* * * * * * * * *  Paquete  FSQL_FUNCTIONS   * * * * * * * * *
--**************************************************************
CREATE OR REPLACE PACKAGE FSQL_FUNCTIONS AS
-- WNDS=Write No Database State --> No permite que la funcin modifique la Bd
-- WNPS/RNPS=Write/Read No Package State --> No escribe/lee variables del paquete

--********************** Funciones de PRESENTACIN **********************--
FUNCTION fshow2 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN VARCHAR2;
PRAGMA RESTRICT_REFERENCES (fshow2,WNDS,WNPS,RNPS);
--PRAGMA INTERFACE(c,fshow);

FUNCTION fshow3 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  LEN    IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN VARCHAR2; 
PRAGMA RESTRICT_REFERENCES (fshow3,WNDS,WNPS,RNPS);

FUNCTION fshow3_len1 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN VARCHAR2;
PRAGMA RESTRICT_REFERENCES (fshow3_len1,WNDS,WNPS,RNPS);

--********************** Comparador difuso FEQ **********************--
FUNCTION FEQ_UNKNOWN (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_UNKNOWN,WNDS,WNPS,RNPS);
FUNCTION FEQ_UNDEFINED (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_UNDEFINED,WNDS,WNPS,RNPS);
FUNCTION FEQ_NULL (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_NULL,WNDS,WNPS,RNPS);

FUNCTION FEQ_crisp_finter(crisp  IN NUMBER,
                         X IN NUMBER, Y IN NUMBER, margen NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_crisp_finter,WNDS,WNPS,RNPS);
FUNCTION FEQ_crisp_aprox(crisp  IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_crisp_aprox,WNDS,WNPS,RNPS);
FUNCTION FEQ_t1_t1(crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_t1_t1,WNDS,WNPS,RNPS);
FUNCTION FEQ_crisp_trape(crisp  IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_crisp_trape,WNDS,WNPS,RNPS);
FUNCTION FEQ_t1_t2 (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_t1_t2,WNDS,WNPS,RNPS);

FUNCTION FEQ_crisp (crisp IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_crisp,WNDS,WNPS,RNPS);
FUNCTION FEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_inter,WNDS,WNPS,RNPS);
FUNCTION FEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_aprox,WNDS,WNPS,RNPS);
FUNCTION FEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ_trape,WNDS,WNPS,RNPS);

FUNCTION FEQ (
  OBJ     IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL  IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ,WNDS,WNPS,RNPS);

FUNCTION FEQ3_label_LEN1(
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ3_label_LEN1,WNDS,WNPS,RNPS);

FUNCTION FEQ3_label(
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  length IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ3_label,WNDS,WNPS,RNPS);

FUNCTION FEQ3_UNKNOWN_NULL (
  length IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ3_UNKNOWN_NULL,WNDS,WNPS,RNPS);

FUNCTION FEQ3(
  OBJ     IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  length1 IN FUZZY_COL_LIST.LEN%TYPE,
  length2 IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE, ----------------> Valores del atributo 1 (F)
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  X_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE, ----------------> Valores del atributo 2 (X)
  XP1 IN NUMBER, X1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP2 IN NUMBER, X2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP3 IN NUMBER, X3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP4 IN NUMBER, X4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP5 IN NUMBER, X5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP6 IN NUMBER, X6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP7 IN NUMBER, X7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP8 IN NUMBER, X8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP9 IN NUMBER, X9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP10 IN NUMBER,X10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FEQ3,WNDS,WNPS,RNPS);

FUNCTION CondCrisp(op1 NUMBER, comparador VARCHAR2, op2 NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (CondCrisp,WNDS,WNPS,RNPS);

--********************** Comparador difuso FGT **********************--
FUNCTION FGT_crisp_finter(crisp IN NUMBER,
                         X IN NUMBER, Y IN NUMBER, margen NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_crisp_finter,WNDS,WNPS,RNPS);
FUNCTION FGT_crisp_aprox(crisp IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_crisp_aprox,WNDS,WNPS,RNPS);
FUNCTION FGT_t1_t1(crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_t1_t1,WNDS,WNPS,RNPS);
FUNCTION FGT_crisp_trape(crisp IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_crisp_trape,WNDS,WNPS,RNPS);
FUNCTION FGT_t1_t2 (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_t1_t2,WNDS,WNPS,RNPS);

FUNCTION FGT_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_crisp,WNDS,WNPS,RNPS);

FUNCTION FGT_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_inter,WNDS,WNPS,RNPS);

FUNCTION FGT_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_aprox,WNDS,WNPS,RNPS);

FUNCTION FGT_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT_trape,WNDS,WNPS,RNPS);

FUNCTION FGT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGT,WNDS,WNPS,RNPS);

--********************** Comparador difuso FGEQ **********************--
FUNCTION FGEQ_crisp_finter(crisp IN NUMBER,
                           X IN NUMBER, Y IN NUMBER, margen NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_crisp_finter,WNDS,WNPS,RNPS);
FUNCTION FGEQ_crisp_aprox(crisp IN NUMBER,
                          F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_crisp_aprox,WNDS,WNPS,RNPS);
FUNCTION FGEQ_t1_t1(crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_t1_t1,WNDS,WNPS,RNPS);
FUNCTION FGEQ_crisp_trape(crisp IN NUMBER,
                          F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_crisp_trape,WNDS,WNPS,RNPS);
FUNCTION FGEQ_t1_t2 (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_t1_t2,WNDS,WNPS,RNPS);

FUNCTION FGEQ_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_crisp,WNDS,WNPS,RNPS);

FUNCTION FGEQ_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_inter,WNDS,WNPS,RNPS);

FUNCTION FGEQ_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_aprox,WNDS,WNPS,RNPS);

FUNCTION FGEQ_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ_trape,WNDS,WNPS,RNPS);

FUNCTION FGEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FGEQ,WNDS,WNPS,RNPS);

--********************** Comparador difuso FLT **********************--
FUNCTION FLT_crisp_finter(crisp IN NUMBER,
                          X IN NUMBER, Y IN NUMBER, margen NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_crisp_finter,WNDS,WNPS,RNPS);
FUNCTION FLT_crisp_aprox(crisp IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_crisp_aprox,WNDS,WNPS,RNPS);
FUNCTION FLT_t1_t1(crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_t1_t1,WNDS,WNPS,RNPS);
FUNCTION FLT_crisp_trape(crisp IN NUMBER,
                         F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_crisp_trape,WNDS,WNPS,RNPS);
FUNCTION FLT_t1_t2 (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_t1_t2,WNDS,WNPS,RNPS);

FUNCTION FLT_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_crisp,WNDS,WNPS,RNPS);

FUNCTION FLT_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_inter,WNDS,WNPS,RNPS);

FUNCTION FLT_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_aprox,WNDS,WNPS,RNPS);

FUNCTION FLT_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT_trape,WNDS,WNPS,RNPS);

FUNCTION FLT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLT,WNDS,WNPS,RNPS);

--********************** Comparador difuso FLEQ **********************--
FUNCTION FLEQ_crisp_finter(crisp IN NUMBER,
                           X IN NUMBER, Y IN NUMBER, margen NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_crisp_finter,WNDS,WNPS,RNPS);
FUNCTION FLEQ_crisp_aprox(crisp IN NUMBER,
                          F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_crisp_aprox,WNDS,WNPS,RNPS);
FUNCTION FLEQ_t1_t1(crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_t1_t1,WNDS,WNPS,RNPS);
FUNCTION FLEQ_crisp_trape(crisp IN NUMBER,
                          F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_crisp_trape,WNDS,WNPS,RNPS);
FUNCTION FLEQ_t1_t2 (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_t1_t2,WNDS,WNPS,RNPS);

FUNCTION FLEQ_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_crisp,WNDS,WNPS,RNPS);

FUNCTION FLEQ_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_inter,WNDS,WNPS,RNPS);

FUNCTION FLEQ_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_aprox,WNDS,WNPS,RNPS);

FUNCTION FLEQ_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ_trape,WNDS,WNPS,RNPS);

FUNCTION FLEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (FLEQ,WNDS,WNPS,RNPS);

--************* Comparador difuso NFEQ (FEQ de Necesidad) *************--
FUNCTION NFEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFEQ_crisp,WNDS,WNPS,RNPS);
FUNCTION NFEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFEQ_inter,WNDS,WNPS,RNPS);
FUNCTION NFEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFEQ_aprox,WNDS,WNPS,RNPS);
FUNCTION NFEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFEQ_trape,WNDS,WNPS,RNPS);
FUNCTION NFEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFEQ,WNDS,WNPS,RNPS);

--********************** Comparador difuso NFGT **********************--
FUNCTION NFGT_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGT_crisp,WNDS,WNPS,RNPS);

FUNCTION NFGT_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGT_inter,WNDS,WNPS,RNPS);

FUNCTION NFGT_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGT_aprox,WNDS,WNPS,RNPS);

FUNCTION NFGT_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGT_trape,WNDS,WNPS,RNPS);

FUNCTION NFGT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGT,WNDS,WNPS,RNPS);

--********************** Comparador difuso NFGEQ **********************--
FUNCTION NFGEQ_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGEQ_crisp,WNDS,WNPS,RNPS);

FUNCTION NFGEQ_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGEQ_inter,WNDS,WNPS,RNPS);

FUNCTION NFGEQ_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGEQ_aprox,WNDS,WNPS,RNPS);

FUNCTION NFGEQ_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGEQ_trape,WNDS,WNPS,RNPS);

FUNCTION NFGEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFGEQ,WNDS,WNPS,RNPS);

--********************** Comparador difuso NFLT **********************--
FUNCTION NFLT_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLT_crisp,WNDS,WNPS,RNPS);

FUNCTION NFLT_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLT_inter,WNDS,WNPS,RNPS);

FUNCTION NFLT_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLT_aprox,WNDS,WNPS,RNPS);

FUNCTION NFLT_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLT_trape,WNDS,WNPS,RNPS);

FUNCTION NFLT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLT,WNDS,WNPS,RNPS);

--********************** Comparador difuso NFLEQ **********************--
FUNCTION NFLEQ_crisp (crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLEQ_crisp,WNDS,WNPS,RNPS);

FUNCTION NFLEQ_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLEQ_inter,WNDS,WNPS,RNPS);

FUNCTION NFLEQ_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLEQ_aprox,WNDS,WNPS,RNPS);

FUNCTION NFLEQ_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLEQ_trape,WNDS,WNPS,RNPS);

FUNCTION NFLEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER;
PRAGMA RESTRICT_REFERENCES (NFLEQ,WNDS,WNPS,RNPS);

END FSQL_FUNCTIONS;
/

CREATE OR REPLACE PACKAGE BODY FSQL_FUNCTIONS AS

--********************** Funciones de PRESENTACIN **********************--
----------------------------------------------------------------------
-- Funcin que devuelve la representacin grfica de una columna difusa
-- para atributos de tipo 2
----------------------------------------------------------------------
FUNCTION fshow2 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER) RETURN VARCHAR2 IS

  result FUZZY_OBJECT_LIST.FUZZY_NAME%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN 'UNKNOWN';  -- ||CHR(0);
  ELSIF F_TYPE=1 THEN RETURN 'UNDEFINED';
  ELSIF F_TYPE=2 THEN RETURN 'NULL';
  ELSIF F_TYPE=3 THEN RETURN TO_CHAR(F1);
  ELSIF F_TYPE=4 THEN --label
    SELECT FUZZY_NAME INTO result FROM FUZZY_OBJECT_LIST
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    RETURN result;
  ELSIF F_TYPE=5 THEN -- Interv [F1,F4]
    RETURN '['||TO_CHAR(F1)||','||TO_CHAR(F4)||']';
  ELSIF F_TYPE=6 THEN -- Aprox F1
    RETURN TO_CHAR(F1)||''||TO_CHAR(F4); --F4=F3-F1;
  ELSIF F_TYPE=7 THEN -- Trapecio
    RETURN '['||TO_CHAR(F1)   ||','||TO_CHAR(F2+F1)||
           ','||TO_CHAR(F3+F4)||','||TO_CHAR(F4)   ||']';
  ELSE
    RETURN 'ERROR en Tipo Fuzzy';
  END IF;
END fshow2;

----------------------------------------------------------------------
-- Devuelve la etiqueta asociada al objeto F_ID de la columna (OBJ,COL)
-- en la tabla FOL. Si no existe devuelve '<ERROR>'.
----------------------------------------------------------------------
FUNCTION nombre_label (
  OBJ  IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE)
  RETURN VARCHAR2 IS

  result FUZZY_OBJECT_LIST.FUZZY_NAME%TYPE:='';
BEGIN
  SELECT FUZZY_NAME INTO result FROM FUZZY_OBJECT_LIST
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  RETURN result;
EXCEPTION
  WHEN NO_DATA_FOUND THEN RETURN '<ERROR>';
END nombre_label;

----------------------------------------------------------------------
-- Funcin que devuelve la representacin grfica de una columna difusa
-- para atributos de tipo 3.
-- Suponemos que como mximo una dist. de posibilidad no tiene ms de 10 etiquetas.
-- Los FPi sern de tipo NUMBER(3,2)
----------------------------------------------------------------------
FUNCTION fshow3 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  LEN    IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN VARCHAR2 IS

  result VARCHAR2(350):='';
  P NUMBER :=FP1; -- Posibilidad de cada etiqueta en la tupla
  i INTEGER:=1;   -- Nmero de etiqueta que procesamos
BEGIN
  IF    F_TYPE=0 THEN RETURN 'UNKNOWN';
  ELSIF F_TYPE=1 THEN RETURN 'UNDEFINED';
  ELSIF F_TYPE=2 THEN RETURN 'NULL';
  ELSIF F_TYPE=3 THEN -- SIMPLE
    RETURN FP1||'/'||nombre_label(OBJ,COL,F1);
  ELSIF F_TYPE=4 THEN -- DIST. de POS.
    WHILE P IS NOT NULL AND i<=LEN LOOP
      IF i=1 THEN
         result:=FP1||'/'||nombre_label(OBJ,COL,F1); P:=FP2;
      ELSIF i=2 THEN
         result:=result||','||FP2||'/'||nombre_label(OBJ,COL,F2); P:=FP3;
      ELSIF i=3 THEN
         result:=result||','||FP3||'/'||nombre_label(OBJ,COL,F3); P:=FP4;
      ELSIF i=4 THEN
         result:=result||','||FP4||'/'||nombre_label(OBJ,COL,F4); P:=FP5;
      ELSIF i=5 THEN
         result:=result||','||FP5||'/'||nombre_label(OBJ,COL,F5); P:=FP6;
      ELSIF i=6 THEN
         result:=result||','||FP6||'/'||nombre_label(OBJ,COL,F6); P:=FP7;
      ELSIF i=7 THEN
         result:=result||','||FP7||'/'||nombre_label(OBJ,COL,F7); P:=FP8;
      ELSIF i=8 THEN
         result:=result||','||FP8||'/'||nombre_label(OBJ,COL,F8); P:=FP9;
      ELSIF i=9 THEN
         result:=result||','||FP9||'/'||nombre_label(OBJ,COL,F9); P:=FP10;
      ELSIF i=10 THEN
         result:=result||','||FP10||'/'||nombre_label(OBJ,COL,F10);
      END IF;
      i:=i+1;
    END LOOP;
    RETURN result;
  ELSE
    RETURN 'ERROR en Tipo Fuzzy';
  END IF;
END fshow3;

----------------------------------------------------------------------
-- Funcin que devuelve la representacin grfica de una columna difusa
-- para atributos de tipo 3 con longitud 1.
-- Esta funcin se ha creado para aumentar la eficiencia en la representacin
-- de estos atributos cuando la longitud es 1, algo que suponemos muy usual.
----------------------------------------------------------------------
FUNCTION fshow3_len1 (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN VARCHAR2 IS
BEGIN
  IF    F_TYPE=0 THEN RETURN 'UNKNOWN';
  ELSIF F_TYPE=1 THEN RETURN 'UNDEFINED';
  ELSIF F_TYPE=2 THEN RETURN 'NULL';
  ELSIF F_TYPE IN (3,4) THEN -- Como LEN=1, es lo mismo SIMPLE que DIST.POS.
    IF FP1=1 THEN RETURN  nombre_label(OBJ,COL,F1); -- Si es 1 se omite
    ELSE RETURN FP1||'/'||nombre_label(OBJ,COL,F1); -- Si no es 1 se pone (No normalizado!)
    END IF;
  ELSE
    RETURN 'ERROR en Tipo Fuzzy';
  END IF;
END fshow3_len1;


--********************** Comparador difuso FEQ **********************--

--********************************************************************
-- Compatibilidad de atributos difusos tipo 2 con las constantes difusas:
-- UNKNOWN, UNDEFINED y NULL.
--********************************************************************

----------------------------------------------------------------------
-- Comparacin de compatibilidad de un atributo difuso tipo 2 con la cte. difusa UNKNOWN
----------------------------------------------------------------------
FUNCTION FEQ_UNKNOWN (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER IS
BEGIN
  IF F_TYPE=1 THEN RETURN 0; -- Unknown-Undefined
  ELSE             RETURN 1;
  END IF;
END FEQ_UNKNOWN;

----------------------------------------------------------------------
-- Comparacin de compatibilidad de un atributo difuso tipo 2  3 con la cte. difusa UNDEFINED
----------------------------------------------------------------------
FUNCTION FEQ_UNDEFINED (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (1,2) THEN RETURN 1; -- Undefined-Undefined y Undefined-Null
  ELSE                    RETURN 0;
  END IF;
END FEQ_UNDEFINED;

----------------------------------------------------------------------
-- Comparacin de compatibilidad de un atributo difuso tipo 2 con la cte. difusa NULL
----------------------------------------------------------------------
FUNCTION FEQ_NULL (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER IS
BEGIN
  RETURN 1;
END FEQ_NULL;

----------------------------------------------------------------------
-- Comparacin de un valor crisp con un label (Tipos 1 y 2)
----------------------------------------------------------------------
FUNCTION FEQ_crisp_label (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE)
  RETURN NUMBER
IS
  alfa   FUZZY_LABEL_DEF.ALFA%TYPE;
  beta   FUZZY_LABEL_DEF.ALFA%TYPE;
  gamma  FUZZY_LABEL_DEF.ALFA%TYPE;
  delta  FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta
    FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  IF    crisp>alfa  AND crisp<beta   THEN RETURN ROUND((crisp-alfa)/(beta-alfa),2);
  ELSIF crisp>=beta AND crisp<=gamma THEN RETURN 1;
  ELSIF crisp>gamma AND crisp<delta  THEN RETURN ROUND((delta-crisp)/(delta-gamma),2);
  ELSE  RETURN 0;
  END IF;
END FEQ_crisp_label;

----------------------------------------------------------------------
-- Comparacin de un valor crisp (Tipo 1) con un intervalo [X,Y]
-- Comparacin del tipo: fcol_t1 FEQ [3,6]
-- En ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [X-margen, X, Y, Y+margen]
-- Si no se desea difuminar usar comparacin crisp: fcol_t1 BETWEEN 3 AND 6
----------------------------------------------------------------------
FUNCTION FEQ_crisp_finter (
  crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER, margen IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp>(X-margen) AND crisp<X  THEN RETURN ROUND((crisp-X+margen)/margen,2);
  ELSIF crisp>=X         AND crisp<=Y THEN RETURN 1;
  ELSIF crisp> Y  AND  crisp<Y+margen THEN RETURN ROUND((Y+margen-crisp)/margen,2);
  ELSE  RETURN 0;
  END IF;
END FEQ_crisp_finter;

----------------------------------------------------------------------
-- Comparacin de un valor crisp con un intervalo [X,Y] (Tipo 2)
-- No se exporta: Se usa en FEQ_crisp y FEQ_inter
----------------------------------------------------------------------
FUNCTION FEQ_crisp_inter (
  crisp  IN NUMBER,
  X IN NUMBER, Y IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF crisp BETWEEN X AND Y THEN RETURN 1;
                           ELSE RETURN 0;
  END IF;
END FEQ_crisp_inter;

----------------------------------------------------------------------
-- Comparacin de un valor crisp con un aprox (Tipos 1 y 2)
----------------------------------------------------------------------
FUNCTION FEQ_crisp_aprox (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF crisp>F2 AND crisp<F3 THEN
       -- Margen=F4: SELECT MARGEN INTO margen FROM FUZZY_APPROX_MUCH WHERE OBJ#=OBJ AND COL#=COL;
       RETURN ROUND((F4-ABS(F1-crisp))/F4,2);
  ELSE RETURN 0;
  END IF;
END FEQ_crisp_aprox;

----------------------------------------------------------------------
-- Comparacin de un valor crisp con un crisp que difuminamos a uno
-- aprox (F1 + - F4), por lo que desconocemos F2 y F3 (F4 es el margen).
-- Ejs: Fcol1 FEQ F1
--      Fcol1 FEQ Fcoltipo1
--      Fcol1 FEQ expr_crisp
-- En esos casos podra provocarse un error indicando que no se pueden usar
-- comparadores difusos para comparar valores crisp. En vez de dar error,
-- difumina el valor crisp de la derecha a uno aprox con el margen del
-- atributo de la izquierda.
----------------------------------------------------------------------
FUNCTION FEQ_t1_t1 (crisp  IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF crisp>(F1-F4) AND crisp<(F1+F4) THEN
       -- Margen=F4: SELECT MARGEN INTO margen FROM FUZZY_APPROX_MUCH WHERE OBJ#=OBJ AND COL#=COL;
       RETURN ROUND((F4-ABS(F1-crisp))/F4,2);
  ELSE RETURN 0;
  END IF;
END FEQ_t1_t1;

----------------------------------------------------------------------
-- Comparacin de un valor crisp con trapecio (Tipos 1 y 2)
----------------------------------------------------------------------
FUNCTION FEQ_crisp_trape (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  beta   FUZZY_LABEL_DEF.ALFA%TYPE;
  gamma  FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  -- F_TYPE=7: alfa=F1, delta=F4
  beta :=F2+F1;
  gamma:=F3+F4;
  IF    crisp>F1    AND crisp<beta   THEN RETURN ROUND((crisp-F1)/F2,2);
  ELSIF crisp>=beta AND crisp<=gamma THEN RETURN 1;
  ELSIF crisp>gamma AND crisp<F4     THEN RETURN ROUND((F4-crisp)/(F4-gamma),2);
  ELSE  RETURN 0;
  END IF;
END FEQ_crisp_trape;

----------------------------------------------------------------------
-- Indica el grado de compatibilidad o 'IGUALDAD' (FEQ) de una
-- columna difusa tipo 1 (crisp) con una columna difusa tipo 2.
-- Formato ejemplo: fcol_t1 FEQ fcol_t2
----------------------------------------------------------------------
FUNCTION FEQ_t1_t2 (crisp IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(3);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) = crisp (F1)
    IF crisp=F1  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN RETURN FEQ_crisp_label(crisp,OBJ,COL,F1);
  ELSIF F_TYPE=5 THEN -- crisp = [F1,F4]
    IF crisp BETWEEN F1 AND F4 THEN RETURN 1;
                               ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN RETURN FEQ_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FEQ_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FEQ_t1_t2;

----------------------------------------------------------------------
-- Comparacin de un valor crisp (f_type=3) con otro difuso
----------------------------------------------------------------------
FUNCTION FEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(3);
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(3);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) vs. crisp (F1)
    IF crisp=F1  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN RETURN FEQ_crisp_label(crisp,OBJ,COL,F1);
  ELSIF F_TYPE=5 THEN RETURN FEQ_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN RETURN FEQ_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FEQ_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FEQ_crisp;


--********************************************************************
-- Compatibilidad de un valor LABEL con cualquier valor posible en atributos difusos tipo 2
-- excepto crisp, ya definido arriba.
--********************************************************************
----------------------------------------------------------------------
-- Comparacin de un valor label con un intervalo [X,Y]
----------------------------------------------------------------------
FUNCTION FEQ_label_inter (
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  X IN NUMBER, Y IN NUMBER)
  RETURN NUMBER IS

  a1 FUZZY_LABEL_DEF.ALFA%TYPE;
  b1 FUZZY_LABEL_DEF.ALFA%TYPE;
  g1 FUZZY_LABEL_DEF.ALFA%TYPE;
  d1 FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT ALFA,BETA,GAMMA,DELTA INTO a1,b1,g1,d1 FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  IF d1<=X OR a1>=Y THEN
     RETURN 0;
  ELSIF g1>=X AND b1<=Y THEN
     RETURN 1;
  ELSIF d1>X AND g1<X THEN
       RETURN ROUND((X-d1)/(g1-d1),2);
  ELSE RETURN ROUND((Y-a1)/(b1-a1),2);
  END IF;
END FEQ_label_inter;

----------------------------------------------------------------------
-- Comparacin de un valor label con un aprox
----------------------------------------------------------------------
FUNCTION FEQ_label_aprox (
  OBJ  IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  F1   IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS

  a1 FUZZY_LABEL_DEF.ALFA%TYPE;
  b1 FUZZY_LABEL_DEF.ALFA%TYPE;
  g1 FUZZY_LABEL_DEF.ALFA%TYPE;
  d1 FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT ALFA,BETA,GAMMA,DELTA INTO a1,b1,g1,d1 FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  IF d1<=F2 OR a1>=F3 THEN
     RETURN 0;
  ELSIF g1>=F1 AND b1<=F1 THEN
     RETURN 1;
  ELSIF d1>F2 AND g1<F1 THEN
       RETURN ROUND((d1-F2)/(F4-(g1-d1)),2);
  ELSE RETURN ROUND((F3-a1)/(F4+(b1-a1)),2);
  END IF;
END FEQ_label_aprox;

----------------------------------------------------------------------
-- Comparacin de un valor label con trapecio
----------------------------------------------------------------------
FUNCTION FEQ_label_trape (
  OBJ  IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  F1   IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS

  a1 FUZZY_LABEL_DEF.ALFA%TYPE;
  b1 FUZZY_LABEL_DEF.ALFA%TYPE;
  g1 FUZZY_LABEL_DEF.ALFA%TYPE;
  d1 FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT ALFA,BETA,GAMMA,DELTA INTO a1,b1,g1,d1 FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  -- F_TYPE=7: a2=F1, d2=F4, b2:=F2+F1, g2:=F3+F4
  IF d1<=F1 OR a1>=F4 THEN
     RETURN 0;
  ELSIF g1>=F2+F1 AND b1<=F3+F4 THEN
     RETURN 1;
  ELSIF d1>F1 AND g1<F2+F1 THEN
       RETURN ROUND((d1-F1)/(F2-(g1-d1)),2);
  ELSE RETURN ROUND((F4-a1)/((b1-a1)-F3),2);
  END IF;
END FEQ_label_trape;

----------------------------------------------------------------------
-- Comparacin de un valor label (f_type=4) con una columna difusa.
-- La etiqueta debe estar definida para la columna.
-- En el caso de la condicin: fcol FEQ $label, no se usa esta funcin, sino FEQ_trape,
-- para aumentar la eficiencia al no tener que hallar [a,b,c,d] para cada tupla.
----------------------------------------------------------------------
FUNCTION FEQ_label (
  OBJ  IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  OBJ2 IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS

  a1 FUZZY_LABEL_DEF.ALFA%TYPE;
  b1 FUZZY_LABEL_DEF.ALFA%TYPE;
  g1 FUZZY_LABEL_DEF.ALFA%TYPE;
  d1 FUZZY_LABEL_DEF.ALFA%TYPE;
  a2 FUZZY_LABEL_DEF.ALFA%TYPE;
  b2 FUZZY_LABEL_DEF.ALFA%TYPE;
  g2 FUZZY_LABEL_DEF.ALFA%TYPE;
  d2 FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(4);
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(4);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(4);
  ELSIF F_TYPE=3 THEN RETURN FEQ_crisp_label(F1,OBJ,COL,F_ID);
  ELSIF F_TYPE=4 THEN -- label (F_ID) vs. label (F1)
    SELECT ALFA,BETA,GAMMA,DELTA INTO a1,b1,g1,d1 FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
    SELECT ALFA,BETA,GAMMA,DELTA INTO a2,b2,g2,d2 FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F1;
    IF d1<=a2 OR a1>=d2 THEN
       RETURN 0;
    ELSIF g1>=b2 AND b1<=g2 THEN
       RETURN 1;
    ELSIF d1>a2 AND g1<b2 THEN
         RETURN ROUND((d1-a2)/((b2-a2)-(g1-d1)),2);
    ELSE RETURN ROUND((d2-a1)/((b1-a1)-(g2-d2)),2);
    END IF;
  ELSIF F_TYPE=5 THEN RETURN FEQ_label_inter(OBJ,COL,F_ID,F1,F4);
  ELSIF F_TYPE=6 THEN RETURN FEQ_label_aprox(OBJ,COL,F_ID,F1,F2,F3,F4);
  ELSE                RETURN FEQ_label_trape(OBJ,COL,F_ID,F1,F2,F3,F4);
  END IF;
END FEQ_label;


--********************************************************************
-- Compatibilidad de un valor INTERVALO con cualquier valor posible en atributos difusos tipo 2
-- excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- Comparacin de un valor interv con un aprox
----------------------------------------------------------------------
FUNCTION FEQ_inter_aprox (
  X IN NUMBER, Y IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS

BEGIN
  IF Y<=F2 OR X>=F3 THEN
     RETURN 0;
  ELSIF Y>=F1 AND X<=F1 THEN
     RETURN 1;
  ELSIF Y>F2 AND Y<F1 THEN
       RETURN ROUND((Y-F2)/F4,2);
  ELSE RETURN ROUND((F3-X)/F4,2);
  END IF;
END FEQ_inter_aprox;

----------------------------------------------------------------------
-- Comparacin de un valor interv con trapecio
----------------------------------------------------------------------
FUNCTION FEQ_inter_trape (
  X IN NUMBER, Y IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS

BEGIN
  -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1, gamma:=F3+F4
  IF Y<=F1 OR X>=F4 THEN
     RETURN 0;
  ELSIF Y>=F2+F1 AND X<=F3+F4 THEN
     RETURN 1;
  ELSIF Y>F1 AND X<F2+F1 THEN
       RETURN ROUND((Y-F1)/F2,2);
  ELSE RETURN ROUND((X-F4)/F3,2);
  END IF;
END FEQ_inter_trape;

----------------------------------------------------------------------
-- Comparacin de un valor intervalo [X,Y] (f_type=5) con otro difuso
----------------------------------------------------------------------
FUNCTION FEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(5);
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(5);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(5);
  ELSIF F_TYPE=3 THEN RETURN FEQ_crisp_inter(F1,X,Y);
  ELSIF F_TYPE=4 THEN RETURN FEQ_label_inter(OBJ,COL,F1,X,Y);
  ELSIF F_TYPE=5 THEN -- Interv [X,Y] vs. Interv [F1,F4]
    IF F1<=Y AND F4>=X THEN RETURN 1;
    ELSE                    RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN RETURN FEQ_inter_aprox(X,Y,F1,F2,F3,F4);
  ELSE                RETURN FEQ_inter_trape(X,Y,F1,F2,F3,F4);
  END IF;
END FEQ_inter;


--********************************************************************
-- Compatibilidad de un valor APROX con cualquier valor posible en atributos difusos tipo 2
-- excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- Comparacin de un valor aprox con trapecio
----------------------------------------------------------------------
FUNCTION FEQ_aprox_trape (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS

BEGIN
  -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1, gamma:=F3+F4
  IF A3<=F1 OR A2>=F4 THEN
     RETURN 0;
  ELSIF A1>=F2+F1 AND A1<=F3+F4 THEN
     RETURN 1;
  ELSIF A3>F1 AND A1<F2+F1 THEN
       RETURN ROUND((A3-F1)/(F2+A4),2);
  ELSE RETURN ROUND((F4-A2)/(A4-F3),2);
  END IF;
END FEQ_aprox_trape;

----------------------------------------------------------------------
-- Comparacin de un aprox [A1,A2,A3,A4] (f_type=6) con otro difuso
----------------------------------------------------------------------
FUNCTION FEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(6);
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(6);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(6);
  ELSIF F_TYPE=3 THEN RETURN FEQ_crisp_aprox(F1,A1,A2,A3,A4);
  ELSIF F_TYPE=4 THEN RETURN FEQ_label_aprox(OBJ,COL,F1,A1,A2,A3,A4);
  ELSIF F_TYPE=5 THEN RETURN FEQ_inter_aprox(F1,F4,A1,A2,A3,A4);
  ELSIF F_TYPE=6 THEN -- aprox [A1,A2,A3,A4] vs. aprox [F1,F2,F3,F4]
    IF A3<=F2 OR A2>=F3 THEN
       RETURN 0;
    ELSIF A1=F1 THEN
       RETURN 1;
    ELSIF A3>F2 AND A1<F1 THEN
         RETURN ROUND((A3-F2)/(A4+F4),2);
    ELSE RETURN ROUND((F3-A2)/(A4+F4),2);
    END IF;
  ELSE -- F_TYPE=7
    RETURN FEQ_aprox_trape(A1,A2,A3,A4,F1,F2,F3,F4);
  END IF;
END FEQ_aprox;


--********************************************************************
-- Compatibilidad de un valor TRAPECIO con cualquier valor posible en
-- atributos difusos tipo 2 excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- Comparacin de un valor trape [T1,T2,T3,T4] (f_type=7) con otro difuso
----------------------------------------------------------------------
FUNCTION FEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN FEQ_UNKNOWN(7);
  ELSIF F_TYPE=1 THEN RETURN FEQ_UNDEFINED(7);
  ELSIF F_TYPE=2 THEN RETURN FEQ_NULL(7);
  ELSIF F_TYPE=3 THEN RETURN FEQ_crisp_trape(F1,T1,T2,T3,T4);
  ELSIF F_TYPE=4 THEN RETURN FEQ_label_trape(OBJ,COL,F1,T1,T2,T3,T4);
  ELSIF F_TYPE=5 THEN RETURN FEQ_inter_trape(F1,F4,T1,T2,T3,T4);
  ELSIF F_TYPE=6 THEN RETURN FEQ_aprox_trape(F1,F2,F3,F4,T1,T2,T3,T4);
  ELSE -- F_TYPE=7: Trapecio [T1,T2,T3,T4] vs. Trapecio [F1,F2,F3,F4]
       -- [T1,T2,T3,T4]: a1=T1, b1=T1+T2, g1=T3+T4, d1=T4
       -- [F1,F2,F3,F4]: a2=F1, b2=F1+F2, g2=F3+F4, d2=F4
    IF T4<=F1 OR T1>=F4 THEN
       RETURN 0;
    ELSIF T3+T4>=F1+F2 AND T1+T2<=F3+F4 THEN
       RETURN 1;
    ELSIF T4>F1 AND T3+T4<F1+F2 THEN
         RETURN ROUND((T4-F1)/((F1+F2-F1)-(T3+T4-T4)),2);
    ELSE RETURN ROUND((F4-T1)/((T1+T2-T1)-(F3+F4-F4)),2);
    END IF;
  END IF;
END FEQ_trape;


--********************************************************************
-- Compatibilidad de dos valores cualesquiera en atributos difusos tipo 2
--********************************************************************
----------------------------------------------------------------------
-- Funcin difusa de comparacin: "APROXIMADAMENTE IGUAL",
-- FEQ (Fuzzy EQual).
----------------------------------------------------------------------
FUNCTION FEQ (
  OBJ     IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL  IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF F_TYPE1=0 THEN    -- Operando 1 es UNKNOWN
     RETURN FEQ_UNKNOWN(F_TYPE2);
  ELSIF F_TYPE1=1 THEN -- UNDEFINED
     RETURN FEQ_UNDEFINED(F_TYPE2);
  ELSIF F_TYPE1=2 THEN -- NULL
     RETURN 1; -- FEQ_NULL(F_TYPE2);
  ELSIF F_TYPE1=3 THEN -- CRISP
     RETURN FEQ_crisp(F11,OBJ2,COL2,F_TYPE2,F12,F22,F32,F42);
  ELSIF F_TYPE1=4 THEN -- LABEL
     RETURN FEQ_label(OBJ,COL,F11,OBJ2,COL2,F_TYPE2,F12,F22,F32,F42);
  ELSIF F_TYPE1=5 THEN -- INTERVALO
     RETURN FEQ_inter(F11,F41,OBJ2,COL2,F_TYPE2,F12,F22,F32,F42);
  ELSIF F_TYPE1=6 THEN -- APROX
     RETURN FEQ_aprox(F11,F21,F31,F41,OBJ2,COL2,F_TYPE2,F12,F22,F32,F42);
  ELSE -- F_TYPE1=7: TRAPECIO
     RETURN FEQ_trape(F11,F21,F31,F41,OBJ2,COL2,F_TYPE2,F12,F22,F32,F42);
  END IF;
END FEQ;


--********************************************************************
-- Compatibilidad de dos valores cualesquiera en atributos difusos tipo 3
--********************************************************************
----------------------------------------------------------------------
-- Para ATRIBUTOS TIPO 3: Comparacin de un valor label con una columna
-- en la que FUZZY_COL_LIST.LEN=1 (Slo admiten una etiqueta por columna)
-- Los valores OBJ,COL no tienen que ser los de la columna a comparar, sino los
-- de la columna que tiene definidas las etiquetas en FUZZY_NEARNESS_DEF.
-- Si la columna a comparar aparece a la izquierda en FUZZY_COMPATIBLE_COL,
-- los valores OBJ,COL sern los que aparecen a la derecha en esa tabla.
----------------------------------------------------------------------
FUNCTION FEQ3_label_LEN1(
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN NUMBER) RETURN NUMBER
IS
  d FUZZY_NEARNESS_DEF.DEGREE%TYPE; -- Grado de similitud entre las dos etiquetas
BEGIN
  IF F_ID<F1 THEN
     SELECT DEGREE INTO d FROM FUZZY_NEARNESS_DEF
       WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID1=F_ID AND FUZZY_ID2=F1;
     RETURN ROUND(FP1*d,2);
  ELSIF F_ID>F1 THEN
     SELECT DEGREE INTO d FROM FUZZY_NEARNESS_DEF
       WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID1=F1 AND FUZZY_ID2=F_ID;
     RETURN ROUND(FP1*d,2);
  ELSE -- Son iguales
     RETURN FP1;
  END IF;
EXCEPTION
  WHEN NO_DATA_FOUND THEN -- Error no existe comparacin entre esas 2 etiquetas
     RETURN 0;
END FEQ3_label_LEN1;

----------------------------------------------------------------------
-- Para ATRIBUTOS TIPO 3: Comparacin de un valor label (F_ID con posibilidad 1)
-- con una columna en la que FUZZY_COL_LIST.LEN = arg. length
-- Se usar en una condicin del tipo fcol FEQ $label, (donde label tiene pos. 1).
-- Los valores OBJ,COL no tienen que ser los de la columna a comparar, sino los
-- de la columna que tiene definidas las etiquetas en FUZZY_NEARNESS_DEF.
-- Si la columna a comparar aparece a la izquierda en FUZZY_COMPATIBLE_COL,
-- los valores OBJ,COL sern los que aparecen a la derecha en esa tabla.
----------------------------------------------------------------------
FUNCTION FEQ3_label(
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID   IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE,
  length IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER
IS
  i    INTEGER:=1;
  FPi  NUMBER :=FP1;
  Fi   FUZZY_OBJECT_LIST.FUZZY_ID%TYPE:=F1;
  maxi NUMBER:=0;
  uno  NUMBER;
BEGIN
  IF F_TYPE=0 OR F_TYPE=2 THEN -- Valor de la columna en la tupla es UNKNOWN o NULL
     RETURN 1;
  ELSIF F_TYPE=1 THEN -- UNDEFINED
     RETURN 0;
  ELSIF F_TYPE=3 THEN -- LABEL
     RETURN FEQ3_label_LEN1(OBJ,COL,F_ID,F_TYPE,FP1,F1);
  ELSE -- F_TYPE=4, DIST. POSIBILIDAD
    -- Mximo nmero de etiquetas: length (con length<=10),
    -- Pero puede tener menos! --> Paramos cuando encontramos un valor NULL
    WHILE i<=length AND FPi IS NOT NULL AND Fi IS NOT NULL LOOP
      -- Comparamos la etiqueta (F_ID) con cada una de las etiquetas de la columna
      -- y tomamos el mximo
      uno:= FEQ3_label_LEN1(OBJ,COL,F_ID,F_TYPE,FPi,Fi);
      IF uno>maxi THEN maxi:=uno;
      END IF;

      i:=i+1;
      IF    i=2  THEN FPi:=FP2; Fi:=F2;
      ELSIF i=3  THEN FPi:=FP3; Fi:=F3;
      ELSIF i=4  THEN FPi:=FP4; Fi:=F4;
      ELSIF i=5  THEN FPi:=FP5; Fi:=F5;
      ELSIF i=6  THEN FPi:=FP6; Fi:=F6;
      ELSIF i=7  THEN FPi:=FP7; Fi:=F7;
      ELSIF i=8  THEN FPi:=FP8; Fi:=F8;
      ELSIF i=9  THEN FPi:=FP9; Fi:=F9;
      ELSIF i=10 THEN FPi:=FP10; Fi:=F10;
      END IF;
    END LOOP;
    RETURN ROUND(maxi,2);
  END IF;
END FEQ3_label;

----------------------------------------------------------------------
-- Comparacin de compatibilidad de un atributo difuso tipo 3
-- con la cte. difusa UNKNOWN o NULL
----------------------------------------------------------------------
FUNCTION FEQ3_UNKNOWN_NULL (
  length IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER
IS
  maxi NUMBER:=FP1;
  FPi  NUMBER:=FP2;
  Fi   FUZZY_OBJECT_LIST.FUZZY_ID%TYPE:=F2;
  i    INTEGER:=2;
BEGIN
  IF    F_TYPE=0 THEN RETURN 1;
  ELSIF F_TYPE=1 THEN RETURN 0;
  ELSIF F_TYPE=2 THEN RETURN 1;
  ELSIF F_TYPE=3 THEN RETURN FP1; -- FP1 deber ser 1 (para estar normalizado)
  ELSIF F_TYPE=4 THEN
    -- Tomamos el mximo de todas las etiquetas (debe ser 1 para estar normalizado)
    WHILE i<=length AND FPi IS NOT NULL AND Fi IS NOT NULL LOOP
      IF FPi>maxi THEN maxi:=FPi;
      END IF;

      i:=i+1;
      IF    i=2  THEN FPi:=FP2; Fi:=F2;
      ELSIF i=3  THEN FPi:=FP3; Fi:=F3;
      ELSIF i=4  THEN FPi:=FP4; Fi:=F4;
      ELSIF i=5  THEN FPi:=FP5; Fi:=F5;
      ELSIF i=6  THEN FPi:=FP6; Fi:=F6;
      ELSIF i=7  THEN FPi:=FP7; Fi:=F7;
      ELSIF i=8  THEN FPi:=FP8; Fi:=F8;
      ELSIF i=9  THEN FPi:=FP9; Fi:=F9;
      ELSIF i=10 THEN FPi:=FP10; Fi:=F10;
      END IF;
    END LOOP;
    RETURN ROUND(maxi,2);
  END IF;
END FEQ3_UNKNOWN_NULL;

----------------------------------------------------------------------
-- Para ATRIBUTOS TIPO 3: Comparacin de un atributo tipo 3 con otro.
-- en los que FUZZY_COL_LIST.LEN vale length1 y length2 respectivamente (simpre <=10).
-- Ambos atributos deben ser compatibles con el atributo (OBJ,COL).
-- (OBJ,COL) no tiene que ser una columna de las que se comparan, sino
-- la columna que tiene definidas las etiquetas en FUZZY_NEARNESS_DEF y
-- que debe ser compatible a los dos atributos que se van a comparar.
----------------------------------------------------------------------
FUNCTION FEQ3(
  OBJ     IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  length1 IN FUZZY_COL_LIST.LEN%TYPE,
  length2 IN FUZZY_COL_LIST.LEN%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE, ----------------> Valores del atributo 1 (F)
  FP1 IN NUMBER, F1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP2 IN NUMBER, F2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP3 IN NUMBER, F3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP4 IN NUMBER, F4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP5 IN NUMBER, F5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP6 IN NUMBER, F6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP7 IN NUMBER, F7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP8 IN NUMBER, F8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP9 IN NUMBER, F9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  FP10 IN NUMBER,F10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  X_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE, ----------------> Valores del atributo 2 (X)
  XP1 IN NUMBER, X1 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP2 IN NUMBER, X2 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP3 IN NUMBER, X3 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP4 IN NUMBER, X4 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP5 IN NUMBER, X5 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP6 IN NUMBER, X6 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP7 IN NUMBER, X7 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP8 IN NUMBER, X8 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP9 IN NUMBER, X9 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE,
  XP10 IN NUMBER,X10 IN FUZZY_OBJECT_LIST.FUZZY_ID%TYPE) RETURN NUMBER

IS
  i    INTEGER:=1;
  FPi  NUMBER :=FP1;
  Fi   FUZZY_OBJECT_LIST.FUZZY_ID%TYPE:=F1;
  maxi NUMBER:=0;
  uno  NUMBER;
BEGIN
  IF F_TYPE=0 OR F_TYPE=2 THEN    -- Operando 1 es UNKNOWN o NULL
     RETURN FEQ3_UNKNOWN_NULL(length2,X_TYPE,XP1,X1,XP2,X2,XP3,X3,XP4,X4,XP5 ,X5,
                                             XP6,X6,XP7,X7,XP8,X8,XP9,X9,XP10,X10);
  ELSIF F_TYPE=1 THEN -- UNDEFINED
     RETURN FEQ_UNDEFINED(X_TYPE);
  ELSIF F_TYPE=3 THEN -- LABEL (FP1 debe ser 1 para estar normalizado)
     RETURN ROUND(FP1*FEQ3_label(OBJ,COL,F1,length2,X_TYPE,XP1,X1,XP2,X2,XP3,X3,XP4,X4,XP5,X5,
                                                     XP6,X6,XP7,X7,XP8,X8,XP9,X9,XP10,X10),2);
  ELSIF F_TYPE=4 THEN -- DIST. POSIBILIDAD

    IF X_TYPE=0 OR X_TYPE=2 THEN    -- Operando 2 es UNKNOWN o NULL
       RETURN FEQ3_UNKNOWN_NULL(length1,4,FP1,F1,FP2,F2,FP3,F3,FP4,F4,FP5 ,F5,
                                          FP6,F6,FP7,F7,FP8,F8,FP9,F9,FP10,F10);
    ELSIF X_TYPE=1 THEN -- UNDEFINED
       RETURN FEQ_UNDEFINED(F_TYPE);
    ELSIF X_TYPE=3 THEN -- LABEL (XP1 debe ser 1 para estar normalizado)
       RETURN ROUND(XP1*FEQ3_label(OBJ,COL,X1,length1,4,
                             FP1,F1,FP2,F2,FP3,F3,FP4,F4,FP5 ,F5,
                             FP6,F6,FP7,F7,FP8,F8,FP9,F9,FP10,F10),2);
    ELSIF X_TYPE=4 THEN -- DIST.POS.(F) vs. DIST.POS.(X)
      -- Comparamos todas las etiquetas de F con todas las de X, y devolvemos el mximo
      WHILE i<=length1 AND FPi IS NOT NULL AND Fi IS NOT NULL LOOP
        uno:=FPi*FEQ3_label(OBJ,COL,Fi,length2,4,XP1,X1,XP2,X2,XP3,X3,XP4,X4,XP5,X5,
                                                 XP6,X6,XP7,X7,XP8,X8,XP9,X9,XP10,X10);
        IF uno>maxi THEN maxi:=uno;
        END IF;

        i:=i+1;
        IF    i=2  THEN FPi:=FP2; Fi:=F2;
        ELSIF i=3  THEN FPi:=FP3; Fi:=F3;
        ELSIF i=4  THEN FPi:=FP4; Fi:=F4;
        ELSIF i=5  THEN FPi:=FP5; Fi:=F5;
        ELSIF i=6  THEN FPi:=FP6; Fi:=F6;
        ELSIF i=7  THEN FPi:=FP7; Fi:=F7;
        ELSIF i=8  THEN FPi:=FP8; Fi:=F8;
        ELSIF i=9  THEN FPi:=FP9; Fi:=F9;
        ELSIF i=10 THEN FPi:=FP10; Fi:=F10;
        END IF;
      END LOOP;
      RETURN ROUND(maxi,2);
    END IF;
  END IF;
END FEQ3;

----------------------------------------------------------------------
-- Evala el grado de cumplimiento de una CONDicin CRISP (numrica)
-- (Para calcular el CDEG de un atributo difuso tipo 1)
----------------------------------------------------------------------
FUNCTION CondCrisp(op1 NUMBER, comparador VARCHAR2, op2 NUMBER) RETURN NUMBER IS
BEGIN
  IF comparador='=' THEN
     IF op1=op2 THEN RETURN 1; ELSE RETURN 0; END IF;
  ELSIF comparador='<' THEN
     IF op1<op2 THEN RETURN 1; ELSE RETURN 0; END IF;
  ELSIF comparador='<=' THEN
     IF op1<=op2 THEN RETURN 1;ELSE RETURN 0; END IF;
  ELSIF comparador='>' THEN
     IF op1>op2 THEN RETURN 1; ELSE RETURN 0; END IF;
  ELSIF comparador='>=' THEN
     IF op1>=op2 THEN RETURN 1;ELSE RETURN 0; END IF;
  ELSE -- Distinto: <>, != o =
     IF op1<>op2 THEN RETURN 1;ELSE RETURN 0; END IF;
  END IF;
END CondCrisp;


--**** Para todos los comparadores difusos de POSIBILIDAD (salvo FEQ) ****--

--********************************************************************
-- Comparacin FGT, FLT, FGEQ, FLEQ, MGT y MLT de cualquier valor
-- difuso tipo 2 con las ctes difusas UNKNOWN, UNDEFINED y NULL.
--********************************************************************

----------------------------------------------------------------------
-- Indica si un atributo difuso tipo 2 es 'MAYOR' (FGT), 'MENOR' (FLT)
-- 'MAYOR o IGUAL' (FGEQ), 'MENOR o IGUAL' (FLEQ), 'MUCHO MAYOR' (MGT) o
-- 'MUCHO MENOR' (MLT) que la cte. difusa UNKNOWN
----------------------------------------------------------------------
FUNCTION MayorMenor_UNKNOWN (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER IS
BEGIN
  -- UNKNOWN es 'mayor' (y tambin 'menor') que cualquier cosa, excepto que UNDEFINED
  IF F_TYPE=1 THEN RETURN 0; -- Undefined>Unknown? NO
  ELSE             RETURN 1;
  END IF;
END MayorMenor_UNKNOWN;

----------------------------------------------------------------------
-- Indica si un atributo difuso tipo 2 es 'MAYOR' (FGT), 'MENOR' (FLT)
-- 'MAYOR o IGUAL' (FGEQ), 'MENOR o IGUAL' (FLEQ), 'MUCHO MAYOR' (MGT) o
-- 'MUCHO MENOR' (MLT) que la cte. difusa UNDEFINED
----------------------------------------------------------------------
FUNCTION MayorMenor_UNDEFINED RETURN NUMBER IS
BEGIN
  RETURN 0;
END MayorMenor_UNDEFINED;

----------------------------------------------------------------------
-- Indica si un atributo difuso tipo 2 es 'MAYOR' (FGT), 'MENOR' (FLT)
-- 'MAYOR o IGUAL' (FGEQ), 'MENOR o IGUAL' (FLEQ), 'MUCHO MAYOR' (MGT) o
-- 'MUCHO MENOR' (MLT) que la cte. difusa NULL
----------------------------------------------------------------------
FUNCTION MayorMenor_NULL (F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE) RETURN NUMBER IS
BEGIN
  -- NULL es 'mayor' (y tambin 'menor') que cualquier cosa, excepto que UNDEFINED
  IF F_TYPE=1 THEN RETURN 0; -- Undefined>Null? NO
  ELSE             RETURN 1;
  END IF;
END MayorMenor_NULL;


--********************** Comparador difuso FGT **********************--

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR' (FGT) que un intervalo [X,Y]
-- Comparacin del tipo: fcol_t1 FGT [3,6]
-- En ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [X-margen, X, Y, Y+margen]
-- Se difumina porque:
--	1. Permite una gran expresividad, escribiendo un intervalo
--       en vez de un trapecio.
--       No obstante, esta comparacin es equivalente a fcol_t1 FGT #6
--	2. Si no se desea difuminar usar comparacin crisp: fcol_t1 > 6
-- Con un crisp, la Posibilidad y la Necesidad son iguales.
----------------------------------------------------------------------
FUNCTION FGT_crisp_finter (
  crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER, margen IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp>=(Y+margen) THEN RETURN 1;
  ELSIF crisp> Y          THEN RETURN ROUND( (crisp-Y)/margen ,2);
  ELSE  RETURN 0;
  END IF;
END FGT_crisp_finter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR' (FGT) que un intervalo [X,Y]
-- No se exporta: Se usa en comparaciones internas.
-- Este no se difumina porque el intervalo [X,Y] es un atributo de una
-- relacin difusa.
----------------------------------------------------------------------
FUNCTION FGT_crisp_inter (crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF crisp>Y THEN RETURN 1;
             ELSE RETURN 0;
  END IF;
END FGT_crisp_inter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR' (FGT) que un valor aprox
-- Caso ejemplo: fcol_t1 FGT #6
-- Valor aprox:  F1 + - F4 (donde F4 es el margen: F1-F4=F2 y F1+F4=F3)
----------------------------------------------------------------------
FUNCTION FGT_crisp_aprox (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp>=F3 THEN RETURN 1;
  ELSIF crisp> F1 THEN RETURN ROUND( (crisp-F1)/F4 ,2);
  ELSE RETURN 0;
  END IF;
END FGT_crisp_aprox;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR' (FGT) que un valor crisp que
-- difuminamos a aprox
-- Caso ejemplo: fcol_t1 FGT 6 (equivalente a fcol_t1 FGT #6)
----------------------------------------------------------------------
FUNCTION FGT_t1_t1 (crisp IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF    crisp>=(F1+F4) THEN RETURN 1; -- F3=F1+F4
  ELSIF crisp> F1 THEN RETURN ROUND( (crisp-F1)/F4 ,2);
  ELSE RETURN 0;
  END IF;
END FGT_t1_t1;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR' (FGT) que un trapecio
-- Caso ejemplo: fcol_t1 FGT $[1,4,7,9]
----------------------------------------------------------------------
FUNCTION FGT_crisp_trape (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
  IF    crisp>=F4   THEN RETURN 1;
  ELSIF crisp>F3+F4 THEN RETURN ROUND( (F3+F4-crisp)/F3 ,2);
  ELSE  RETURN 0;
  END IF;
END FGT_crisp_trape;

----------------------------------------------------------------------
-- Indica si una columna difusa tipo 1 (crisp) es 'MAYOR' (FGT) que una
-- columna tipo 2. Formato: fcol_t1 FGT fcol_t2
----------------------------------------------------------------------
FUNCTION FGT_t1_t2 (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma  FUZZY_LABEL_DEF.ALFA%TYPE;
  delta  FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) > crisp (F1)
    IF crisp>F1  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- crisp > label
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    crisp>=delta THEN RETURN 1;
    ELSIF crisp> gamma THEN RETURN ROUND( (gamma-crisp)/(gamma-delta) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN RETURN FGT_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN RETURN FGT_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FGT_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FGT_t1_t2;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR' (FGT) que un valor crisp
-- Caso ejemplo: fcol_t2 FGT 8. Tambin: fcol_t2 FGT fcol_t1
--********************************************************************
FUNCTION FGT_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1>crisp  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGT crisp (=FGEQ)
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    gamma>=crisp THEN RETURN 1;
    ELSIF delta> crisp THEN RETURN ROUND((crisp-delta)/(gamma-delta),2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGT crisp
    IF F4>crisp THEN RETURN 1;
    ELSE             RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FGT crisp (=FGEQ)
    IF    F1>=crisp THEN RETURN 1;
    ELSIF F3> crisp THEN RETURN ROUND((F3-crisp)/F4,2);
    ELSE  RETURN 0;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FGT crisp (=FGEQ)
    IF    crisp>=F4    THEN RETURN 0;
    ELSIF F3+F4>=crisp THEN RETURN 1;
    ELSE                    RETURN ROUND((crisp-F4)/F3,2);
    END IF;
  END IF;
END FGT_crisp;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR' (FGT) que un intervalo [X,Y]
-- Caso ejemplo: fcol_t2 FGT [X,Y]
--********************************************************************
FUNCTION FGT_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(5); -- 5 es el tipo intervalo
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(5);
  ELSIF F_TYPE=3 THEN -- RETURN FGT_crisp_inter(F1,X,Y); (Lo desarrollamos aqu para ganar eficiencia)
    IF F1>Y THEN RETURN 1; -- Comparacin F1 FGT [X,Y]
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGT [X,Y]
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    gamma>=Y THEN RETURN 1;
    ELSIF delta> Y THEN RETURN ROUND((Y-delta)/(gamma-delta),2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGT [X,Y]
    IF F1>Y THEN RETURN 1;
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FGT [X,Y]
    IF    F1>=Y THEN RETURN 1;
    ELSIF F3> Y THEN RETURN ROUND( (F3-Y)/F4 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGT [X,Y]
    IF    Y>=F4    THEN RETURN 0;
    ELSIF F3+F4>=Y THEN RETURN 1;
    ELSE                RETURN ROUND((Y-F4)/F3,2);
    END IF;
  END IF;
END FGT_inter;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR' (FGT) que un aprox [A1,A2,A3,A4]
-- Caso ejemplo: fcol_t2 FGT #A1
--********************************************************************
FUNCTION FGT_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(6); -- 6 es el tipo aprox
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(6);
  ELSIF F_TYPE=3 THEN RETURN FGT_crisp_aprox(F1,A1,A2,A3,A4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGT #A1
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    delta<=A1 THEN RETURN 0;
    ELSIF gamma< A3 THEN RETURN ROUND( (A1-delta)/(gamma-delta-A4) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGT #A1
    IF    F4<=A1 THEN RETURN 0;
    ELSIF F4< A3 THEN RETURN ROUND( (F4-A1)/A4 ,2);
    ELSE         RETURN 1;
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 FGT #A1
    IF    F3<=A1 THEN RETURN 0;
    ELSIF F1< A3 THEN RETURN ROUND( (F3-A1)/(A4+F4) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGT #A1
    IF    F4   <=A1 THEN RETURN 0;
    ELSIF F3+F4< A3 THEN RETURN ROUND( (A1-F4)/(F3-A4) ,2);
    ELSE  RETURN 1;
    END IF;
  END IF;
END FGT_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR' (FGT) que un trapecio
-- Caso ejemplo: fcol_t2 FGT $[T1,T2,T3,T4]
--********************************************************************
FUNCTION FGT_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  -- Trapecio: alfa=T1, delta=T4, beta:=T2+T1; gamma:=T3+T4;
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(7); -- 7 es el tipo trapecio
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(7);
  ELSIF F_TYPE=3 THEN RETURN FGT_crisp_trape(F1,T1,T2,T3,T4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGT $[T1,T2+T1,T3+T4,T4]
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    delta<=(T3+T4) THEN RETURN 0;
    ELSIF gamma< T4      THEN RETURN ROUND( (T3+T4-delta)/(T3+gamma-delta) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGT $[T1,T2+T1,T3+T4,T4]
    IF    F4<=(T3+T4) THEN RETURN 0;
    ELSIF F4< T4 THEN RETURN ROUND( (T3+T4-F4)/T3 ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 FGT $[T1,T2+T1,T3+T4,T4]
    IF    F3<=(T3+T4) THEN RETURN 0;
    ELSIF F1< T4      THEN RETURN ROUND( (T3+T4-F3)/(T3-F4) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGT $[T1,T2+T1,T3+T4,T4]
    IF    F4   <=(T3+T4) THEN RETURN 0;
    ELSIF F3+F4< T4      THEN RETURN ROUND( (T3+T4-F4)/(T3+F3) ,2);
    ELSE  RETURN 1;
    END IF;
  END IF;
END FGT_trape;

--********************************************************************
-- Funcin difusa de comparacin: "APROXIMADAMENTE MAYOR QUE",
-- FGT (Fuzzy Greater Than).
-- Indica si una columna difusa tipo 2 es 'MAYOR' (FGT) que otra
-- Caso ejemplo: fcol1_t2 FGT fcol2_t2
--********************************************************************
FUNCTION FGT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE2=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE1);
  ELSIF F_TYPE2=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE2=2 THEN RETURN MayorMenor_NULL(F_TYPE1);
  ELSIF F_TYPE1=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE2); -- Para ahorrar llamadas
  ELSIF F_TYPE1=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE1=2 THEN RETURN MayorMenor_NULL(F_TYPE2);
  ELSIF F_TYPE2=3 THEN RETURN FGT_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=4 THEN -- LABEL: Calculamos los valores del trapecio
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F12;
    RETURN FGT_trape(alfa,beta-alfa,gamma-delta,delta,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN -- INTERVALO
    RETURN FGT_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=6 THEN -- APROX
    RETURN FGT_aprox(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE -- F_TYPE2=7: TRAPECIO: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
    RETURN FGT_trape(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END FGT;


--********************** Comparador difuso FGEQ **********************--

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que un intervalo [X,Y]
-- Comparacin del tipo: fcol_t1 FGEQ [3,6]
-- En ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [X-margen, X, Y, Y+margen]
-- Si no se desea difuminar usar comparacin crisp: fcol_t1 >= 3
----------------------------------------------------------------------
FUNCTION FGEQ_crisp_finter (
  crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER, margen IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    (X-margen)>=crisp THEN RETURN 0;
  ELSIF crisp>=X          THEN RETURN 1;
  ELSE                         RETURN ROUND((crisp-X+margen)/margen,2);
  END IF;
END FGEQ_crisp_finter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que un intervalo [X,Y]
-- No se exporta
----------------------------------------------------------------------
FUNCTION FGEQ_crisp_inter (crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF crisp>=X THEN RETURN 1;
              ELSE RETURN 0;
  END IF;
END FGEQ_crisp_inter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que un valor aprox
-- Caso ejemplo: fcol_t1 FGEQ #6
-- Valor aprox:  F1 + - F4 (donde F4 es el margen: F1-F4=F2 y F1+F4=F3)
----------------------------------------------------------------------
FUNCTION FGEQ_crisp_aprox (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp>=F1 THEN RETURN 1;
  ELSIF crisp> F2 THEN RETURN ROUND((crisp-F2)/F4,2);
  ELSE RETURN 0;
  END IF;
END FGEQ_crisp_aprox;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que otro crisp que
-- difuminamos a un aprox F1 + - F4
-- Caso ejemplo: fcol_t1 FGEQ 6
----------------------------------------------------------------------
FUNCTION FGEQ_t1_t1 (crisp  IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF    crisp>=F1      THEN RETURN 1;
  ELSIF crisp> (F1-F4) THEN RETURN ROUND((crisp-F1+F4)/F4,2);
  ELSE RETURN 0;
  END IF;
END FGEQ_t1_t1;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que un trapecio
-- Caso ejemplo: fcol_t1 FGEQ $[1,4,7,9]
----------------------------------------------------------------------
FUNCTION FGEQ_crisp_trape (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
  IF    F1>=crisp    THEN RETURN 0;
  ELSIF crisp>=F2+F1 THEN RETURN 1;
  ELSE                    RETURN ROUND((crisp-F1)/F2,2);
  END IF;
END FGEQ_crisp_trape;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MAYOR o IGUAL' (FGEQ) que una etiqueta
-- No se exporta: Se usa en otras funciones.
----------------------------------------------------------------------
FUNCTION FGEQ_crisp_label (
  crisp IN NUMBER,
  OBJ   IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID  IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  IF    alfa>=crisp THEN RETURN 0;
  ELSIF crisp>=beta THEN RETURN 1;
  ELSE                   RETURN ROUND((crisp-alfa)/(beta-alfa),2);
  END IF;
END FGEQ_crisp_label;

----------------------------------------------------------------------
-- Indica si una columna difusa tipo 1 (crisp) es 'MAYOR o IGUAL' (FGEQ) que una
-- columna tipo 2. Formato: fcol_t1 FGEQ fcol_t2
----------------------------------------------------------------------
FUNCTION FGEQ_t1_t2 (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) >= crisp (F1)
    IF crisp>=F1 THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN RETURN FGEQ_crisp_label(crisp,OBJ,COL,F1);
  ELSIF F_TYPE=5 THEN RETURN FGEQ_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN RETURN FGEQ_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FGEQ_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FGEQ_t1_t2;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR o IGUAL' (FGEQ) que un valor crisp
-- Caso ejemplo: fcol_t2 FGEQ 8. Tambin: fcol_t2 FGEQ fcol_t1
--********************************************************************
FUNCTION FGEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1>=crisp THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGEQ crisp
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    gamma>=crisp THEN RETURN 1;
    ELSIF delta> crisp THEN RETURN ROUND((crisp-delta)/(gamma-delta),2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGEQ crisp
    IF F4>=crisp THEN RETURN 1;
    ELSE              RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FGEQ crisp
    IF    F1>=crisp THEN RETURN 1;
    ELSIF F3> crisp THEN RETURN ROUND((F3-crisp)/F4,2);
    ELSE  RETURN 0;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FGEQ crisp
    IF    crisp>=F4    THEN RETURN 0;
    ELSIF F3+F4>=crisp THEN RETURN 1;
    ELSE                    RETURN ROUND((crisp-F4)/F3,2);
    END IF;
  END IF;
END FGEQ_crisp;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR o IGUAL' (FGEQ) que un intervalo [X,Y]
-- Caso ejemplo: fcol_t2 FGEQ [X,Y]
--********************************************************************
FUNCTION FGEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(5); -- 5 es el tipo intervalo
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(5);
  ELSIF F_TYPE=3 THEN
    IF F1>=X THEN RETURN 1; -- Comparacin F1 FGEQ [X,Y]
    ELSE          RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGEQ [X,Y]
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    gamma>=X THEN RETURN 1;
    ELSIF delta> X THEN RETURN ROUND((X-delta)/(gamma-delta),2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGEQ [X,Y]
   IF F4>=X THEN RETURN 1;
   ELSE          RETURN 0;
   END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FGEQ [X,Y]
    IF    F1>=X THEN RETURN 1;
    ELSIF F3> X THEN RETURN ROUND((F3-X)/F4,2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGEQ [X,Y]
    IF    X    >=F4 THEN RETURN 0;
    ELSIF F3+F4>=X  THEN RETURN 1;
    ELSE                 RETURN ROUND((X-F4)/F3,2);
    END IF;
  END IF;
END FGEQ_inter;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR o IGUAL' (FGEQ) que un aprox [A1,A2,A3,A4]
-- Caso ejemplo: fcol_t2 FGEQ #A1
--********************************************************************
FUNCTION FGEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(6); -- 6 es el tipo aprox
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(6);
  ELSIF F_TYPE=3 THEN -- Comparacin F1 FGEQ #A1
    IF    F1>=A1 THEN RETURN 1;
    ELSIF F1> A2 THEN RETURN ROUND((F1-A2)/A4,2);
    ELSE              RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGEQ #A1
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    gamma>=A1 THEN RETURN 1;
    ELSIF delta> A2 THEN RETURN ROUND((delta-A2)/(A4-gamma+delta),2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGEQ #A1
    IF    F1>=A1 THEN RETURN 1;
    ELSIF F1> A2 THEN RETURN ROUND((F1-A2)/A4,2);
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 FGEQ #A1
    IF    F1>=A1 THEN RETURN 1;
    ELSIF F3> A2 THEN RETURN ROUND((F3-A2)/(A4+F4),2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGEQ #A1
    IF    A2   >=F4 THEN RETURN 0;
    ELSIF F3+F4>=A1 THEN RETURN 1;
    ELSE                 RETURN ROUND((F4-A2)/(A4-F3),2);
    END IF;
  END IF;
END FGEQ_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MAYOR o IGUAL' (FGEQ) que un trapecio
-- Caso ejemplo: fcol_t2 FGEQ $[T1,T2,T3,T4]
--********************************************************************
FUNCTION FGEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  -- Trapecio: alfa=T1, delta=T4, beta:=T2+T1; gamma:=T3+T4;
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(7); -- 7 es el tipo trapecio
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(7);
  ELSIF F_TYPE=3 THEN -- Comparacin F1 FGEQ $[T1,T2+T1,T3+T4,T4]
    IF    T1>=F1    THEN RETURN 0;
    ELSIF F1>=T1+T2 THEN RETURN 1;
    ELSE                 RETURN ROUND((F1-T1)/T2,2);
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FGEQ $[T1,T2+T1,T3+T4,T4]
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    T1   >=delta THEN RETURN 0;
    ELSIF gamma>=T1+T2 THEN RETURN 1;
    ELSE                    RETURN ROUND((T1-delta)/(gamma-delta-T2),2);
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FGEQ $[T1,T2+T1,T3+T4,T4]
    IF    T1>=F4    THEN RETURN 0;
    ELSIF F4>=T1+T2 THEN RETURN 1;
    ELSE                 RETURN ROUND((F4-T1)/T2,2);
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 FGEQ $[T1,T2+T1,T3+T4,T4]
    IF    T1>=F3    THEN RETURN 0;
    ELSIF F1>=T1+T2 THEN RETURN 1;
    ELSE                 RETURN ROUND((F3-T1)/(F4+T2),2);
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] FGEQ $[T1,T2+T1,T3+T4,T4]
    IF T1>=F4 THEN RETURN 0;
    ELSIF F3+F4>=T1+T2 THEN RETURN 1;
    ELSE RETURN ROUND((T1-F4)/(F3-T2),2);
    END IF;
  END IF;
END FGEQ_trape;

--********************************************************************
-- Funcin difusa de comparacin: "APROXIMADAMENTE MAYOR o IGUAL",
-- FGEQ (Fuzzy Greater or EQual).
-- Indica si una columna difusa tipo 2 es 'MAYOR o IGUAL' (FGEQ) que otra
-- Caso ejemplo: fcol1_t2 FGEQ fcol2_t2
--********************************************************************
FUNCTION FGEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE2=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE1);
  ELSIF F_TYPE2=1 OR F_TYPE1=1
                  THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE2=2 THEN RETURN MayorMenor_NULL(F_TYPE1);
  ELSIF F_TYPE1=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE2); -- Para ahorrar llamadas
  ELSIF F_TYPE1=2 THEN RETURN MayorMenor_NULL(F_TYPE2);
  ELSIF F_TYPE2=3 THEN -- CRISP
    RETURN FGEQ_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=4 THEN -- LABEL: Calculamos los valores del trapecio
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F12;
    RETURN FGEQ_trape(alfa,beta-alfa,gamma-delta,delta,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN -- INTERVALO
    RETURN FGEQ_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=6 THEN -- APROX
    RETURN FGEQ_aprox(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE -- F_TYPE2=7: TRAPECIO: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
    RETURN FGEQ_trape(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END FGEQ;


--********************** Comparador difuso FLT **********************--

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR' (FLT) que un intervalo [X,Y]
-- Comparacin del tipo: fcol_t1 FLT [3,6]
-- En ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [X-margen, X, Y, Y+margen]
-- Si no se desea difuminar usar comparacin crisp: fcol_t1 < 3
----------------------------------------------------------------------
FUNCTION FLT_crisp_finter (
  crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER, margen IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp<=(X-margen) THEN RETURN 1;
  ELSIF crisp<X           THEN RETURN ROUND( (X-crisp)/margen ,2);
  ELSE                         RETURN 0;
  END IF;
END FLT_crisp_finter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR' (FLT) que un intervalo [X,Y]
-- No se exporta
----------------------------------------------------------------------
FUNCTION FLT_crisp_inter (crisp IN NUMBER, X IN NUMBER, Y IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF crisp<X THEN RETURN 1;
             ELSE RETURN 0;
  END IF;
END FLT_crisp_inter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR' (FLT) que un valor aprox
-- Caso ejemplo: fcol_t1 FLT #6
-- Valor aprox:  F1 + - F4 (donde F4 es el margen: F1-F4=F2 y F1+F4=F3)
----------------------------------------------------------------------
FUNCTION FLT_crisp_aprox (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp<=F2 THEN RETURN 1;
  ELSIF crisp< F1 THEN RETURN ROUND( (F1-crisp)/F4 ,2);
  ELSE  RETURN 0;
  END IF;
END FLT_crisp_aprox;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR' (FLT) que un valor crisp que
-- se difumina a uno aprox. F1 + - F4
-- Caso ejemplo: fcol_t1 FLT 6
----------------------------------------------------------------------
FUNCTION FLT_t1_t1 (crisp  IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF    crisp<=(F1-F4) THEN RETURN 1;
  ELSIF crisp< F1      THEN RETURN ROUND( (F1-crisp)/F4 ,2);
  ELSE  RETURN 0;
  END IF;
END FLT_t1_t1;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR' (FLT) que un trapecio
-- Caso ejemplo: fcol_t1 FLT $[1,4,7,9]
----------------------------------------------------------------------
FUNCTION FLT_crisp_trape (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
  IF    crisp<=F1   THEN RETURN 1;
  ELSIF crisp<F1+F2 THEN RETURN ROUND( (F1+F2-crisp)/F2 ,2);
  ELSE  RETURN 0;
  END IF;
END FLT_crisp_trape;

----------------------------------------------------------------------
-- Indica si una columna difusa tipo 1 (crisp) es 'MENOR' (FLT) que una
-- columna tipo 2. Formato: fcol_t1 FLT fcol_t2
----------------------------------------------------------------------
FUNCTION FLT_t1_t2 (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) < crisp (F1)
    IF crisp<F1  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- crisp < label
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    crisp<=alfa THEN RETURN 1;
    ELSIF crisp< beta THEN RETURN ROUND( (beta-crisp)/(beta-alfa) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN RETURN FLT_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN RETURN FLT_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FLT_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FLT_t1_t2;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR' (FLT) que un valor crisp
-- Caso ejemplo: fcol_t2 FLT 8. Tambin: fcol_t2 FLT fcol_t1
--********************************************************************
FUNCTION FLT_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1<crisp  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FLT crisp
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=crisp THEN RETURN 0;
    ELSIF beta> crisp THEN RETURN ROUND( (crisp-alfa)/(beta-alfa) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FLT crisp
    IF F1<crisp THEN RETURN 1;
    ELSE             RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FLT crisp
    IF    F1<=crisp THEN RETURN 1;
    ELSIF F2< crisp THEN RETURN ROUND( (crisp-F2)/F4 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FLT crisp
    IF    F1   >=crisp THEN RETURN 0;
    ELSIF F1+F2<=crisp THEN RETURN 1;
    ELSE                    RETURN ROUND( (crisp-F1)/F2 ,2);
    END IF;
  END IF;
END FLT_crisp;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR' (FLT) que un intervalo [X,Y]
-- Caso ejemplo: fcol_t2 FLT [X,Y]
--********************************************************************
FUNCTION FLT_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(5); -- 5 es el tipo intervalo
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(5);
  ELSIF F_TYPE=3 THEN -- Comparacin F1 FLT [X,Y]
    IF F1<X THEN RETURN 1;
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FLT [X,Y]
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=X THEN RETURN 0;
    ELSIF beta> X THEN RETURN ROUND( (X-alfa)/(beta-alfa) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FLT [X,Y]
    IF F1<X THEN RETURN 1;
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FLT [X,Y]
    IF    F1<=X THEN RETURN 1;
    ELSIF F2< X THEN RETURN ROUND( (X-F2)/F4 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FLT [X,Y]
    IF    F1   >=X THEN RETURN 0;
    ELSIF F1+F2<=X THEN RETURN 1;
    ELSE                RETURN ROUND( (X-F1)/F2 ,2);
    END IF;
  END IF;
END FLT_inter;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR' (FLT) que un aprox [A1,A2,A3,A4]
-- Caso ejemplo: fcol_t2 FLT #A1
--********************************************************************
FUNCTION FLT_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(6);
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(6);
  ELSIF F_TYPE=3 THEN -- Comparacin F1 FLT #A1
    IF    F1<=A2 THEN RETURN 1;
    ELSIF F1>=A1 THEN RETURN 0;
    ELSE              RETURN ROUND( (A1-F1)/A4 ,2);
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FLT #A1
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=A1 THEN RETURN 0;
    ELSIF beta> A2 THEN RETURN ROUND( (A1-alfa)/(beta-alfa+A4) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FLT #A1
    IF    F1<=A2 THEN RETURN 1;
    ELSIF F1>=A1 THEN RETURN 0;
    ELSE              RETURN ROUND( (A1-F1)/A4 ,2);
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FLT #A1
    IF    F2>=A1 THEN RETURN 0;
    ELSIF F1> A2 THEN RETURN ROUND( (A1-F2)/(F4+A4) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FLT #A1
    IF    F1   >=A1 THEN RETURN 0;
    ELSIF F2+F1> A2 THEN RETURN ROUND( (A1-F1)/(F2+A4) ,2);
    ELSE  RETURN 1;
    END IF;
  END IF;
END FLT_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR' (FLT) que un trapecio
-- Caso ejemplo: fcol_t2 FLT $[T1,T2,T3,T4]
--********************************************************************
FUNCTION FLT_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(7);
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(7);
  ELSIF F_TYPE=3 THEN -- Comparacin F1 FLT $[T1,T2+T1,T3+T4,T4]
    IF    F1<=T1    THEN RETURN 1;
    ELSIF F1>=T1+T2 THEN RETURN 0;
    ELSE                 RETURN ROUND( (T1+T2-F1)/T2 ,2);
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FLT $[T1,T2+T1,T3+T4,T4]
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=T1+T2 THEN RETURN 0;
    ELSIF beta> T1    THEN RETURN ROUND( (T1+T2-alfa)/(beta-alfa+T2) ,2);
    ELSE  RETURN 1;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FLT $[T1,T2+T1,T3+T4,T4]
    IF    F1<=T1    THEN RETURN 1;
    ELSIF F1>=T1+T2 THEN RETURN 0;
    ELSE                 RETURN ROUND( (T1+T2-F1)/T2 ,2);
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FLT $[T1,T2+T1,T3+T4,T4]
    IF    F1<=T1    THEN RETURN 1;
    ELSIF F2< T1+T2 THEN RETURN ROUND( (T1+T2-F2)/(F4+T2) ,2);
    ELSE                 RETURN 1;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FLT $[T1,T2+T1,T3+T4,T4]
    IF    F1   >=T1+T2 THEN RETURN 0;
    ELSIF F2+F1> T1    THEN RETURN ROUND( (T1+T2-F1)/(F2+T2) ,2);
    ELSE  RETURN 1;
    END IF;
  END IF;
END FLT_trape;

--********************************************************************
-- Funcin difusa de comparacin: "APROXIMADAMENTE MENOR QUE",
-- FLT (Fuzzy Less Than).
-- Indica si una columna difusa tipo 2 es 'MENOR QUE' (FLT) otra
-- Caso ejemplo: fcol1_t2 FLT fcol2_t2
--********************************************************************
FUNCTION FLT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE2=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE1);
  ELSIF F_TYPE2=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE2=2 THEN RETURN MayorMenor_NULL(F_TYPE1);
  ELSIF F_TYPE1=0 THEN RETURN MayorMenor_UNKNOWN(F_TYPE2);
  ELSIF F_TYPE1=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE1=2 THEN RETURN MayorMenor_NULL(F_TYPE2);
  ELSIF F_TYPE2=3 THEN RETURN FLT_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=4 THEN -- LABEL: Calculamos los valores del trapecio
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F12;
    RETURN FLT_trape(alfa,beta-alfa,gamma-delta,delta,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN -- INTERVALO
    RETURN FLT_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=6 THEN -- APROX
    RETURN FLT_aprox(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE -- F_TYPE2=7: TRAPECIO
    RETURN FLT_trape(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END FLT;


--********************** Comparador difuso FLEQ **********************--

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR o IGUAL' (FLEQ) que un intervalo [X,Y]
-- Comparacin del tipo: fcol_t1 FLEQ [3,6]
-- En ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [X-margen, X, Y, Y+margen]
-- Si no se desea difuminar usar comparacin crisp: fcol_t1 <= 6
----------------------------------------------------------------------
FUNCTION FLEQ_crisp_finter (
  crisp  IN NUMBER, X IN NUMBER, Y IN NUMBER, margen IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF   (Y+margen)<=crisp THEN RETURN 0;
  ELSIF Y>=crisp         THEN RETURN 1;
  ELSE                        RETURN ROUND((Y+margen-crisp)/margen,2);
  END IF;
END FLEQ_crisp_finter;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR o IGUAL' (FLEQ) que un valor aprox
-- Caso ejemplo: fcol_t1 FLEQ #6
-- Valor aprox:  F1 + - F4 (donde F4 es el margen: F1-F4=F2 y F1+F4=F3)
----------------------------------------------------------------------
FUNCTION FLEQ_crisp_aprox (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    crisp<=F1 THEN RETURN 1;
  ELSIF crisp< F3 THEN RETURN ROUND((F3-crisp)/F4,2);
  ELSE RETURN 0;
  END IF;
END FLEQ_crisp_aprox;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR o IGUAL' (FLEQ) que un valor crisp que
-- se difumina a un aprox F1 + - F4
-- Caso ejemplo: fcol_t1 FLEQ 6
----------------------------------------------------------------------
FUNCTION FLEQ_t1_t1 (crisp  IN NUMBER, F1 IN NUMBER, F4 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF    crisp<=F1      THEN RETURN 1;
  ELSIF crisp< (F1+F4) THEN RETURN ROUND((F1+F4-crisp)/F4,2);
  ELSE RETURN 0;
  END IF;
END FLEQ_t1_t1;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR o IGUAL' (FLEQ) que un trapecio
-- Caso ejemplo: fcol_t1 FLEQ $[1,4,7,9]
----------------------------------------------------------------------
FUNCTION FLEQ_crisp_trape (
  crisp  IN NUMBER,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN -- F_TYPE=7: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
  IF    F4   <=crisp THEN RETURN 0;
  ELSIF F3+F4>=crisp THEN RETURN 1;
  ELSE                    RETURN ROUND((crisp-F4)/F3,2);
  END IF;
END FLEQ_crisp_trape;

----------------------------------------------------------------------
-- Indica si un valor crisp es 'MENOR o IGUAL' (FLEQ) que una etiqueta
-- No se exporta (caso fcol_t1 FLEQ $label se traduce a FLEQ_crisp_trape)
----------------------------------------------------------------------
FUNCTION FLEQ_crisp_label (
  crisp IN NUMBER,
  OBJ   IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_ID  IN FUZZY_LABEL_DEF.FUZZY_ID%TYPE) RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
    WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F_ID;
  IF    delta<=crisp THEN RETURN 1;
  ELSIF gamma>=crisp THEN RETURN 0;
  ELSE                    RETURN ROUND((crisp-delta)/(gamma-delta),2);
  END IF;
END FLEQ_crisp_label;

----------------------------------------------------------------------
-- Indica si una columna difusa tipo 1 (crisp) es 'MENOR o IGUAL' (FLEQ) que una
-- columna tipo 2. Formato: fcol_t1 FLEQ fcol_t2
----------------------------------------------------------------------
FUNCTION FLEQ_t1_t2 (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (crisp) <= crisp (F1)
    IF crisp<=F1 THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN RETURN FLEQ_crisp_label(crisp,OBJ,COL,F1);
  ELSIF F_TYPE=5 THEN -- crisp <= [F1,F4]
    IF crisp<=F4 THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN RETURN FLEQ_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE                RETURN FLEQ_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FLEQ_t1_t2;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (FLEQ) que un valor crisp
-- Caso ejemplo: fcol_t2 FLEQ 8. Tambin: fcol_t2 FLEQ fcol_t1
--********************************************************************
FUNCTION FLEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE=0 THEN RETURN MayorMenor_UNKNOWN(3); -- 3 es el tipo crisp
  ELSIF F_TYPE=1 THEN RETURN MayorMenor_UNDEFINED;
  ELSIF F_TYPE=2 THEN RETURN MayorMenor_NULL(3);
  ELSIF F_TYPE=3 THEN -- crisp (F1) <= crisp (crisp)
    IF F1<=crisp THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label FLEQ crisp
    RETURN FGEQ_crisp_label(crisp,OBJ,COL,F1);
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] FLEQ crisp
    RETURN FGEQ_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 FLEQ crisp
    RETURN FGEQ_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] FLEQ crisp
    RETURN FGEQ_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END FLEQ_crisp;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (FLEQ) que un intervalo [X,Y]
-- Caso ejemplo: fcol_t2 FLEQ [X,Y]
--********************************************************************
FUNCTION FLEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN FGEQ(NULL,NULL,5,X,NULL,NULL,Y,
              OBJ,COL,F_TYPE,F1,F2,F3,F4);
END FLEQ_inter;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (FLEQ) que un aprox [A1,A2,A3,A4]
-- Caso ejemplo: fcol_t2 FLEQ #A1
--********************************************************************
FUNCTION FLEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN FGEQ(NULL,NULL,     6,A1,A2,A3,A4,
              OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
END FLEQ_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (FLEQ) que un trapecio
-- Caso ejemplo: fcol_t2 FLEQ $[T1,T2,T3,T4]
--********************************************************************
FUNCTION FLEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN FGEQ(NULL,NULL,     7,T1,T2,T3,T4,
              OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
END FLEQ_trape;

--********************************************************************
-- Funcin difusa de comparacin: "APROXIMADAMENTE MENOR o IGUAL",
-- FLEQ (Fuzzy Less or EQual).
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (FLEQ) que otra
-- Caso ejemplo: fcol1_t2 FLEQ fcol2_t2
--********************************************************************
FUNCTION FLEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER IS
BEGIN
  RETURN FGEQ(OBJ2,COL2,F_TYPE2,F12,F22,F32,F42,
              OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
END FLEQ;


--********************** Comparador difuso NFEQ **********************--

--********************************************************************
-- Indica la Necesidad de que un valor X sea F. NO es conmutativa.
-- Ambos valorex X y F son trapecios que se suponen bien definidos, es decir:
-- X1<=X2<=X3<=X4 y F1<=F2<=F3<=F4
--********************************************************************
FUNCTION NECESIDAD(X1 IN NUMBER, X2 IN NUMBER, X3 IN NUMBER, X4 IN NUMBER,
                   F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
--dbms_output.put_line(X1||','||X2||','||X3||','||X4||'-'||F1||','||F2||','||F3||','||F4);
  IF (X2<=F1 AND X1<>F2) OR   -- Los <> comprueban, en cada lado del trapecio,
     (F4<=X3 AND X4<>F3) THEN -- que no sean de pendiente infinita (como un inter).
     RETURN 0;
  ELSIF X1<F2 THEN
     IF F3<X4 THEN
          RETURN ROUND(LEAST((X2-F1)/((F2-F1)-(X1-X2)),
                             (X3-F4)/((F3-F4)-(X4-X3))),2);
     ELSE RETURN ROUND((X2-F1)/((F2-F1)-(X1-X2)),2);
     END IF;
  ELSIF F3<X4 THEN
       RETURN ROUND((X3-F4)/((F3-F4)-(X4-X3)),2);
  ELSE RETURN 1;
  END IF;
END NECESIDAD;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea un valor crisp
-- Caso ejemplo: fcol_t2 NFEQ 8. Tambin: fcol_t2 NFEQ fcol_t1
-- En realidad esta comparacin se usar muy poco, ya que practicamente
-- en todos los casos esta Necesidad es cero.
-- El caso ms interesante es cuando queremos ver las tuplas que toman
-- justo un valor crisp X en una columna difusa tipo 2: fcol_t2 NFEQ X
-- Esa condicin tambin puede ser vista usando la columna difusa tipo 2
-- en una comparacin crisp: fcol_t2 = 'X' (hay que poner las comillas).
--********************************************************************
FUNCTION NFEQ_crisp (crisp IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1=crisp THEN RETURN 1;
                ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFEQ crisp
     SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
       WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
     IF   alfa=beta AND beta=gamma AND gamma=delta AND alfa=crisp THEN
          RETURN 1; -- Un caso muy hipottico!
     ELSE RETURN 0;
     END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFEQ crisp
     IF F1=F4 AND F1=crisp THEN RETURN 1; -- Un caso raro
     ELSE                       RETURN 0;
     END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFEQ crisp
     IF F4=0 AND F1=crisp THEN RETURN 1; -- Un caso raro
     ELSE                      RETURN 0;
     END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] NFEQ crisp
     IF F2=0 AND F3=0 and F1=F4 and F1=crisp THEN
          RETURN 1; -- Un caso muy rarito!
     ELSE RETURN 0;
     END IF;
  END IF;
END NFEQ_crisp;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 est en un intervalo [X,Y]
-- Caso ejemplo: fcol_t2 NFEQ [X,Y]
--********************************************************************
FUNCTION NFEQ_inter (X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN
    IF F1 BETWEEN X AND Y THEN RETURN 1; -- Comparacin F1 NFEQ [X,Y]
    ELSE                       RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFEQ [X,Y]
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    RETURN NECESIDAD(alfa,beta,gamma,delta,X,X,Y,Y);
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFEQ [X,Y]
    IF F1>=X AND F4<=Y THEN RETURN 1;
    ELSE                    RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFEQ [X,Y]
    RETURN NECESIDAD(F2,F1,F1,F3,X,X,Y,Y);
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFEQ [X,Y]
    RETURN NECESIDAD(F1,F2+F1,F3+F4,F4,X,X,Y,Y);
  END IF;
END NFEQ_inter;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 est en un APROX #A1
-- Caso ejemplo: fcol_t2 NFEQ #A1
--********************************************************************
FUNCTION NFEQ_aprox (A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- Comparacin F1 NFEQ #A1
        RETURN FEQ_crisp_aprox(F1,A1,A2,A3,A4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFEQ #A1
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
       WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    RETURN NECESIDAD(alfa,beta,gamma,delta,A2,A1,A1,A3);
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFEQ #A1
    RETURN NECESIDAD(F1,F1,F4,F4,A2,A1,A1,A3);
  ELSIF F_TYPE=6 THEN -- #F1 NFEQ #A1
    RETURN NECESIDAD(F2,F1,F1,F3,A2,A1,A1,A3);
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFEQ #A1
    RETURN NECESIDAD(F1,F2+F1,F3+F4,F4,A2,A1,A1,A3);
  END IF;
END NFEQ_aprox;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 est en un trapecio
-- Caso ejemplo: fcol_t2 NFEQ $[T1,T2,T3,T4]
--********************************************************************
FUNCTION NFEQ_trape (T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  -- Trapecio: alfa=T1, delta=T4, beta:=T2+T1; gamma:=T3+T4;
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- Comparacin F1 NFEQ $[T1,T2+T1,T3+T4,T4]
        RETURN FEQ_crisp_trape(F1,T1,T2,T3,T4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFEQ $[T1,T2+T1,T3+T4,T4]
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    RETURN NECESIDAD(alfa,beta,gamma,delta,T1,T2+T1,T3+T4,T4);
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFEQ $[T1,T2+T1,T3+T4,T4]
    RETURN NECESIDAD(F1,F1,F4,F4,T1,T2+T1,T3+T4,T4);
  ELSIF F_TYPE=6 THEN -- #F1 NFEQ $[T1,T2+T1,T3+T4,T4]
    RETURN NECESIDAD(F2,F1,F1,F3,T1,T2+T1,T3+T4,T4);
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFEQ $[T1,T2+T1,T3+T4,T4]
    RETURN NECESIDAD(F1,F2+F1,F3+F4,F4,T1,T2+T1,T3+T4,T4);
  END IF;
END NFEQ_trape;

--********************************************************************
-- Funcin difusa de comparacin que devuelve la NECESIDAD, NFEQ,
-- de que una columna difusa tipo 2 sea 'IGUAL' a otra columna tipo 2.
-- Caso ejemplo: fcol1_t2 NFEQ fcol2_t2
--********************************************************************
FUNCTION NFEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF F_TYPE1 IN (0,1,2) OR F_TYPE2 IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE2=3 THEN -- CRISP
     RETURN NFEQ_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=4 THEN -- LABEL: Calculamos los valores del trapecio
     SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
       WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F12;
     RETURN NFEQ_trape(alfa,beta-alfa,gamma-delta,delta,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN -- INTERVALO
     RETURN NFEQ_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=6 THEN -- APROX
     RETURN NFEQ_aprox(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE -- F_TYPE2=7: TRAPECIO: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
     RETURN NFEQ_trape(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END NFEQ;


--********************** Comparador difuso NFGT **********************--

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR' (NFGT)
-- que un valor crisp
-- Caso ejemplo: fcol_t2 NFGT 8. Tambin: fcol_t2 NFGT fcol_t1
--********************************************************************
FUNCTION NFGT_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1>crisp  THEN RETURN 1; -- Esto no sigue la frmula gral. para trapecios
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFGT crisp
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=crisp THEN RETURN 1;
    ELSIF beta> crisp THEN RETURN ROUND( (beta-crisp)/(beta-alfa) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFGT crisp
    IF F1>crisp THEN RETURN 1;
    ELSE             RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFGT crisp
    IF    F2>=crisp THEN RETURN 1;
    ELSIF F1> crisp THEN RETURN ROUND( (F1-crisp)/F4 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] NFGT crisp
    IF    F1   >=crisp THEN RETURN 1;
    ELSIF F2+F1> crisp THEN RETURN ROUND( (F1+F2-crisp)/F2 ,2);
    ELSE  RETURN 0;
    END IF;
  END IF;
END NFGT_crisp;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR' (NFGT)
-- que un intervalo [X,Y]. Caso ejemplo: fcol_t2 NFGT [X,Y]
--********************************************************************
FUNCTION NFGT_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN
    IF F1>Y THEN RETURN 1; -- Comparacin F1 NFGT [X,Y]
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFGT [X,Y]
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=Y THEN RETURN 1;
    ELSIF beta> Y THEN RETURN ROUND( (beta-Y)/(beta-alfa) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFGT [X,Y]
    IF F1>Y THEN RETURN 1;
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFGT [X,Y]
    IF    F2>=Y THEN RETURN 1;
    ELSIF F1> Y THEN RETURN ROUND( (F1-Y)/F4 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFGT [X,Y]
    IF    F1   >=Y THEN RETURN 1;
    ELSIF F2+F1> Y THEN RETURN ROUND( (F1+F2-Y)/F2 ,2);
    ELSE  RETURN 0;
    END IF;
  END IF;
END NFGT_inter;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR' (NFGT)
-- que un aprox [A1,A2,A3,A4]. Caso ejemplo: fcol_t2 NFGT #A1
--********************************************************************
FUNCTION NFGT_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3          THEN RETURN FGT_crisp_aprox(F1,A1,A2,A3,A4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFGT #A1
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=A3 THEN RETURN 1;
    ELSIF beta> A1 THEN RETURN ROUND( (beta-A1)/(A4+beta-alfa) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFGT #A1
    IF    F1>=A3 THEN RETURN 1;
    ELSIF F1> A1 THEN RETURN ROUND( (F1-A1)/A4 ,2);
    ELSE         RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 NFGT #A1
    IF    F2>=A3 THEN RETURN 1;
    ELSIF F1> A1 THEN RETURN ROUND( (F1-A1)/(A4+F4) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFGT #A1
    IF    F1   >=A3 THEN RETURN 1;
    ELSIF F2+F1> A1 THEN RETURN ROUND( (F2+F1-A1)/(A4+F2) ,2);
    ELSE  RETURN 0;
    END IF;
  END IF;
END NFGT_aprox;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR' (NFGT)
-- que un trapecio. Caso ejemplo: fcol_t2 NFGT $[T1,T2,T3,T4]
--********************************************************************
FUNCTION NFGT_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  -- Trapecio: alfa=T1, delta=T4, beta:=T2+T1; gamma:=T3+T4;
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3          THEN RETURN FGT_crisp_trape(F1,T1,T2,T3,T4);
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFGT $[T1,T2+T1,T3+T4,T4]
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=T4    THEN RETURN 1;
    ELSIF beta> T3+T4 THEN RETURN ROUND( (T3+T4-beta)/(alfa-beta+T3) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFGT $[T1,T2+T1,T3+T4,T4]
    IF    F1>=T4    THEN RETURN 1;
    ELSIF F1> T3+T4 THEN RETURN ROUND( (T3+T4-F1)/T3 ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- #F1 NFGT $[T1,T2+T1,T3+T4,T4]
    IF    F2>=T4    THEN RETURN 1;
    ELSIF F1> T3+T4 THEN RETURN ROUND( (F1-T3-T4)/(F4-T3) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSE -- F_TYPE=7: Comparacin $[F1,F2+F1,F3+F4,F4] NFGT $[T1,T2+T1,T3+T4,T4]
    IF    F1   >=T4    THEN RETURN 1;
    ELSIF F1+F2> T3+T4 THEN RETURN ROUND( (F1+F2-T3-T4)/(F2-T3) ,2);
    ELSE  RETURN 0;
    END IF;
  END IF;
END NFGT_trape;

--********************************************************************
-- Funcin difusa de comparacin: "NECESARIAMENTE MAYOR QUE": NFGT
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR' (NFGT)
-- que otra. Caso ejemplo: fcol1_t2 NFGT fcol2_t2
--********************************************************************
FUNCTION NFGT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER
IS
  alfa  FUZZY_LABEL_DEF.ALFA%TYPE;  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  beta  FUZZY_LABEL_DEF.ALFA%TYPE;  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE1 IN (0,1,2) OR F_TYPE2 IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE2=3 THEN -- CRISP
    RETURN NFGT_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=4 THEN -- LABEL: Calculamos los valores del trapecio
    SELECT ALFA,BETA,GAMMA,DELTA INTO alfa,beta,gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ2 AND COL#=COL2 AND FUZZY_ID=F12;
    RETURN NFGT_trape(alfa,beta-alfa,gamma-delta,delta,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN -- INTERVALO
    RETURN NFGT_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=6 THEN -- APROX
    RETURN NFGT_aprox(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE -- F_TYPE2=7: TRAPECIO: alfa=F1, delta=F4, beta:=F2+F1; gamma:=F3+F4;
    RETURN NFGT_trape(F12,F22,F32,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END NFGT;

--********************** Comparador difuso NFGEQ **********************--

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR o IGUAL'
-- (NFGEQ) que un valor crisp.
-- Caso ejemplo: fcol_t2 NFGEQ 8. Tambin: fcol_t2 NFGEQ fcol_t1
--********************************************************************
FUNCTION NFGEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  alfa FUZZY_LABEL_DEF.ALFA%TYPE;
  beta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE IN (3,5) THEN -- crisp (F1) > crisp (crisp) y [F1,F4] NFGEQ crisp
    IF F1>=crisp THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFGEQ crisp
    SELECT ALFA,BETA INTO alfa,beta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    alfa>=crisp THEN RETURN 1;
    ELSIF beta> crisp THEN RETURN ROUND( (crisp-beta)/(alfa-beta) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFGEQ crisp
    RETURN FLT_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] NFGEQ crisp
    RETURN FLT_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END NFGEQ_crisp;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR o IGUAL'
-- (NFGEQ) que un intervalo [X,Y]. Caso ejemplo: fcol_t2 NFGEQ [X,Y]
--********************************************************************
FUNCTION NFGEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE IN (3,5) THEN -- F1 NFGEQ [X,Y] y [F1,F4] NFGEQ [X,Y]
    IF F1>=X THEN RETURN 1;
             ELSE RETURN 0;
    END IF;
  ELSE RETURN FLT (NULL,NULL,5,X,NULL,NULL,Y,
                   OBJ,COL,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFGEQ_inter;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR o IGUAL'
-- (NFGEQ) que un aprox [A1,A2,A3,A4]. Caso ejemplo: fcol_t2 NFGEQ #A1
--********************************************************************
FUNCTION NFGEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSE RETURN FLT (NULL,NULL,     6,A1,A2,A3,A4,
                   OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFGEQ_aprox;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR o IGUAL'
-- (NFGEQ) que un trapecio. Caso ejemplo: fcol_t2 NFGEQ $[T1,T2,T3,T4]
--********************************************************************
FUNCTION NFGEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSE RETURN FLT (NULL,NULL,     7,T1,T2,T3,T4,
                   OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFGEQ_trape;

--********************************************************************
-- Funcin difusa de comparacin: "NECESARIAMENTE MAYOR o IGUAL QUE", NFGEQ.
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MAYOR o IGUAL QUE'
-- (NFGEQ) otra. Caso ejemplo: fcol1_t2 NFGEQ fcol2_t2
--********************************************************************
FUNCTION NFGEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF F_TYPE1 IN (0,1,2) OR F_TYPE2 IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE2=3 THEN
    RETURN NFGEQ_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN
    RETURN NFGEQ_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE RETURN FLT (OBJ2,COL2,F_TYPE2,F12,F22,F32,F42,
                   OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END NFGEQ;

--********************** Comparador difuso NFLT **********************--

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR' (NFLT)
-- que un valor crisp.
-- Caso ejemplo: fcol_t2 NFLT 8. Tambin: fcol_t2 NFLT fcol_t1
--********************************************************************
FUNCTION NFLT_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1<crisp  THEN RETURN 1;
                 ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFLT crisp
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    crisp>=delta THEN RETURN 1;
    ELSIF crisp> gamma THEN RETURN ROUND( (gamma-crisp)/(gamma-delta) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFLT crisp
    RETURN FGT_crisp_inter(crisp,F1,F4);
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFLT crisp
    RETURN FGT_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] NFLT crisp
    RETURN FGT_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END NFLT_crisp;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR' (NFLT)
-- que un intervalo [X,Y]. Caso ejemplo: fcol_t2 NFLT [X,Y]
--********************************************************************
FUNCTION NFLT_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN NFGT (NULL,NULL,5,X,NULL,NULL,Y,
               OBJ,COL,F_TYPE,F1,F2,F3,F4);
END NFLT_inter;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR' (NFLT)
-- que un aprox [A1,A2,A3,A4]. Caso ejemplo: fcol_t2 NFLT #A1
--********************************************************************
FUNCTION NFLT_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN NFGT (NULL,NULL,     6,A1,A2,A3,A4,
               OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
END NFLT_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR' (NFLT) que un trapecio
-- Caso ejemplo: fcol_t2 NFLT $[T1,T2,T3,T4]
--********************************************************************
FUNCTION NFLT_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  RETURN NFGT (NULL,NULL,     7,T1,T2,T3,T4,
               OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
END NFLT_trape;

--********************************************************************
-- Funcin difusa de comparacin: "NECESARIAMENTE MENOR QUE", NFLT.
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR QUE'
-- (NFLT) otra. Caso ejemplo: fcol1_t2 NFLT fcol2_t2
--********************************************************************
FUNCTION NFLT (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER IS
BEGIN
  RETURN NFGT (OBJ2,COL2,F_TYPE2,F12,F22,F32,F42,
               OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
END NFLT;

--********************** Comparador difuso NFLEQ **********************--

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR o IGUAL'
-- (NFLEQ) que un valor crisp.
-- Caso ejemplo: fcol_t2 NFLEQ 8. Tambin: fcol_t2 NFLEQ fcol_t1
--********************************************************************
FUNCTION NFLEQ_crisp (
  crisp  IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER ,F4 IN NUMBER)
  RETURN NUMBER
IS
  gamma FUZZY_LABEL_DEF.ALFA%TYPE;
  delta FUZZY_LABEL_DEF.ALFA%TYPE;
BEGIN
  IF    F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- crisp (F1) > crisp (crisp)
    IF F1<=crisp  THEN RETURN 1;
                  ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=4 THEN -- Comparacin $label NFLEQ crisp
    SELECT GAMMA,DELTA INTO gamma,delta FROM FUZZY_LABEL_DEF
      WHERE OBJ#=OBJ AND COL#=COL AND FUZZY_ID=F1;
    IF    crisp>=delta THEN RETURN 1;
    ELSIF crisp> gamma THEN RETURN ROUND( (gamma-crisp)/(gamma-delta) ,2);
    ELSE  RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- Comparacin [F1,F4] NFLEQ crisp
    IF F4<=crisp THEN RETURN 1;
    ELSE              RETURN 0;
    END IF;
  ELSIF F_TYPE=6 THEN -- Comparacin #F1 NFLEQ crisp
    RETURN FGT_crisp_aprox(crisp,F1,F2,F3,F4);
  ELSE  -- Comparacin $[F1,F2+F1,F3+F4,F4] NFLEQ crisp
    RETURN FGT_crisp_trape(crisp,F1,F2,F3,F4);
  END IF;
END NFLEQ_crisp;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR o IGUAL'
-- (NFLEQ) que un intervalo [X,Y]. Caso ejemplo: fcol_t2 NFLEQ [X,Y]
--********************************************************************
FUNCTION NFLEQ_inter (
  X IN NUMBER, Y IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE=3 THEN -- crisp (F1) <= [X,Y]
    IF F1<=Y THEN RETURN 1;
             ELSE RETURN 0;
    END IF;
  ELSIF F_TYPE=5 THEN -- [F1,F4] <= [X,Y]
    IF F4<=Y THEN RETURN 1;
             ELSE RETURN 0;
    END IF;
  ELSE RETURN FGT (NULL,NULL,5,X,NULL,NULL,Y,
                   OBJ,COL,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFLEQ_inter;

--********************************************************************
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR o IGUAL' (NFLEQ)
-- que un aprox [A1,A2,A3,A4]. Caso ejemplo: fcol_t2 NFLEQ #A1
--********************************************************************
FUNCTION NFLEQ_aprox (
  A1 IN NUMBER, A2 IN NUMBER, A3 IN NUMBER, A4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSE RETURN FGT (NULL,NULL,     6,A1,A2,A3,A4,
                   OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFLEQ_aprox;

--********************************************************************
-- Indica si una columna difusa tipo 2 es 'MENOR o IGUAL' (NFLEQ) que un trapecio
-- Caso ejemplo: fcol_t2 NFLEQ $[T1,T2,T3,T4]
--********************************************************************
FUNCTION NFLEQ_trape (
  T1 IN NUMBER, T2 IN NUMBER, T3 IN NUMBER, T4 IN NUMBER,
  OBJ    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F1 IN NUMBER, F2 IN NUMBER, F3 IN NUMBER, F4 IN NUMBER)
  RETURN NUMBER IS
BEGIN
  IF F_TYPE IN (0,1,2) THEN RETURN 0;
  ELSE RETURN FGT (NULL,NULL,     7,T1,T2,T3,T4,
                   OBJ ,COL ,F_TYPE,F1,F2,F3,F4);
  END IF;
END NFLEQ_trape;

--********************************************************************
-- Funcin difusa de comparacin: "NECESARIAMENTE MENOR o IGUAL QUE", NFLEQ.
-- Indica la Necesidad de que una columna difusa tipo 2 sea 'MENOR o IGUAL QUE'
-- (NFLEQ) otra. Caso ejemplo: fcol1_t2 NFLEQ fcol2_t2
--********************************************************************
FUNCTION NFLEQ (
  OBJ1    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL1 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE1 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F11 IN NUMBER, F21 IN NUMBER, F31 IN NUMBER, F41 IN NUMBER,
  OBJ2    IN FUZZY_LABEL_DEF.OBJ#%TYPE, COL2 IN FUZZY_LABEL_DEF.OBJ#%TYPE,
  F_TYPE2 IN FUZZY_COL_LIST.F_TYPE%TYPE,
  F12 IN NUMBER, F22 IN NUMBER, F32 IN NUMBER ,F42 IN NUMBER) RETURN NUMBER IS
BEGIN
  IF F_TYPE1 IN (0,1,2) OR F_TYPE2 IN (0,1,2) THEN RETURN 0;
  ELSIF F_TYPE2=3 THEN
    RETURN NFLEQ_crisp(F12,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSIF F_TYPE2=5 THEN
    RETURN NFLEQ_inter(F12,F42,OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  ELSE RETURN FGT (OBJ2,COL2,F_TYPE2,F12,F22,F32,F42,
                   OBJ1,COL1,F_TYPE1,F11,F21,F31,F41);
  END IF;
END NFLEQ;

END FSQL_FUNCTIONS;
/
